/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger.theme;

import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.theme.Theme;
import com.adarshr.gradle.testlogger.theme.ThemeType;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.testng.TestNGOptions;

public class ThemeFactory
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ThemeFactory() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Theme getTheme(Test test, TestLoggerExtension extension) {
        return (Theme)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance(ThemeFactory.resolveThemeType(test, extension).getThemeClass(), (Object[])new Object[]{extension}), Theme.class);
    }

    private static ThemeType resolveThemeType(Test test, TestLoggerExtension extension) {
        ThemeType themeType = extension.getTheme();
        if (ScriptBytecodeAdapter.compareEqual((Object)test.getProject().getGradle().getStartParameter().getConsoleOutput(), (Object)ConsoleOutput.Plain)) {
            ThemeType themeType2;
            themeType = themeType2 = ThemeType.PLAIN;
        }
        if (ThemeFactory.isParallelMode(test) && !themeType.isParallel()) {
            ThemeType themeType3;
            themeType = themeType3 = ThemeType.fromName(themeType.getParallelFallback());
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)themeType), (Object)((Object)extension.getTheme()))) {
            test.getProject().getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{test.getName()}, new String[]{"Test logger theme for task ", " overridden "}).plus((GString)new GStringImpl(new Object[]{extension.getTheme().getName(), themeType.getName()}, new String[]{"from ", " to ", ""}))));
        }
        return themeType;
    }

    private static boolean isParallelMode(Test test) {
        boolean testNgParallelMode = test.getOptions() instanceof TestNGOptions && DefaultTypeTransformation.booleanUnbox((Object)((TestNGOptions)ScriptBytecodeAdapter.asType((Object)test.getOptions(), TestNGOptions.class)).getParallel());
        return test.getMaxParallelForks() > 1 || testNgParallelMode;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ThemeFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

