/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2002 - 2007 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package flex.messaging.config;

import java.util.List;
import java.util.ArrayList;

/**
 * A log maintains a series of Loggers for each logging category and
 * Targets are established that listen for LogEvents on those Loggers.
 *
 * @author Peter Farland
 * @exclude
 */
public class LoggingSettings extends PropertiesSettings
{
    private final List targets;

    public LoggingSettings()
    {
        targets = new ArrayList();
    }

    public void addTarget(TargetSettings t)
    {
        targets.add(t);
    }

    public List getTargets()
    {
        return targets;
    }
}
