/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Language;
import com.aerospike.client.LargeSet;
import com.aerospike.client.LargeStack;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.DeleteCommand;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.command.ScanExecutor;
import com.aerospike.client.command.WriteCommand;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.QueryAggregateExecutor;
import com.aerospike.client.query.QueryRecordExecutor;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AerospikeClient {
    protected Cluster cluster;

    public AerospikeClient(String hostname, int port) throws AerospikeException {
        this(new ClientPolicy(), new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, Host ... hosts) throws AerospikeException {
        if (policy == null) {
            policy = new ClientPolicy();
        }
        this.cluster = new Cluster(policy, hosts);
        this.cluster.initTendThread();
        if (policy.failIfNotConnected && !this.cluster.isConnected()) {
            throw new AerospikeException.Connection("Failed to connect to host(s): " + Arrays.toString(hosts));
        }
    }

    protected AerospikeClient() {
    }

    protected final void addServer(String hostname, int port) throws AerospikeException {
        Host[] hosts = new Host[]{new Host(hostname, port)};
        if (this.cluster != null) {
            this.cluster.addSeeds(hosts);
            return;
        }
        this.cluster = new Cluster(new ClientPolicy(), hosts);
        this.cluster.initTendThread();
    }

    public final void close() {
        this.cluster.close();
    }

    public final boolean isConnected() {
        return this.cluster.isConnected();
    }

    public final Node[] getNodes() {
        return this.cluster.getNodes();
    }

    public final List<String> getNodeNames() {
        Node[] nodes = this.cluster.getNodes();
        ArrayList<String> names = new ArrayList<String>(nodes.length);
        for (Node node : nodes) {
            names.add(node.getName());
        }
        return names;
    }

    public final void put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        WriteCommand command = new WriteCommand(this.cluster, key);
        command.setWrite(policy, Operation.Type.WRITE, key, bins);
        command.execute(policy);
    }

    public final void append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        WriteCommand command = new WriteCommand(this.cluster, key);
        command.setWrite(policy, Operation.Type.APPEND, key, bins);
        command.execute(policy);
    }

    public final void prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        WriteCommand command = new WriteCommand(this.cluster, key);
        command.setWrite(policy, Operation.Type.PREPEND, key, bins);
        command.execute(policy);
    }

    public final void add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        WriteCommand command = new WriteCommand(this.cluster, key);
        command.setWrite(policy, Operation.Type.ADD, key, bins);
        command.execute(policy);
    }

    public final boolean delete(WritePolicy policy, Key key) throws AerospikeException {
        DeleteCommand command = new DeleteCommand(this.cluster, key);
        command.setDelete(policy, key);
        command.execute(policy);
        return command.getResultCode() == 0;
    }

    public final void touch(WritePolicy policy, Key key) throws AerospikeException {
        WriteCommand command = new WriteCommand(this.cluster, key);
        command.setTouch(policy, key);
        command.execute(policy);
    }

    public final boolean exists(Policy policy, Key key) throws AerospikeException {
        ReadCommand command = new ReadCommand(this.cluster, key);
        command.setExists(key);
        command.execute(policy);
        return command.getResultCode() == 0;
    }

    public final boolean[] exists(Policy policy, Key[] keys2) throws AerospikeException {
        boolean[] existsArray = new boolean[keys2.length];
        BatchExecutor.executeBatch(this.cluster, policy, keys2, existsArray, null, null, 33);
        return existsArray;
    }

    public final Record get(Policy policy, Key key) throws AerospikeException {
        ReadCommand command = new ReadCommand(this.cluster, key);
        command.setRead(key);
        command.execute(policy);
        return command.getRecord();
    }

    public final Record get(Policy policy, Key key, String ... binNames) throws AerospikeException {
        ReadCommand command = new ReadCommand(this.cluster, key);
        command.setRead(key, binNames);
        command.execute(policy);
        return command.getRecord();
    }

    public final Record getHeader(Policy policy, Key key) throws AerospikeException {
        ReadCommand command = new ReadCommand(this.cluster, key);
        command.setReadHeader(key);
        command.execute(policy);
        return command.getRecord();
    }

    public final Record[] get(Policy policy, Key[] keys2) throws AerospikeException {
        Record[] records = new Record[keys2.length];
        BatchExecutor.executeBatch(this.cluster, policy, keys2, null, records, null, 3);
        return records;
    }

    public final Record[] get(Policy policy, Key[] keys2, String ... binNames) throws AerospikeException {
        Record[] records = new Record[keys2.length];
        HashSet<String> names = AerospikeClient.binNamesToHashSet(binNames);
        BatchExecutor.executeBatch(this.cluster, policy, keys2, null, records, names, 1);
        return records;
    }

    public final Record[] getHeader(Policy policy, Key[] keys2) throws AerospikeException {
        Record[] records = new Record[keys2.length];
        BatchExecutor.executeBatch(this.cluster, policy, keys2, null, records, null, 33);
        return records;
    }

    public final Record operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        ReadCommand command = new ReadCommand(this.cluster, key);
        command.setOperate(policy, key, operations);
        command.execute(policy);
        return command.getRecord();
    }

    public final void scanAll(ScanPolicy policy, String namespace, String setName, ScanCallback callback) throws AerospikeException {
        if (policy == null) {
            policy = new ScanPolicy();
        }
        policy.maxRetries = 0;
        Node[] nodes = this.cluster.getNodes();
        if (policy.concurrentNodes) {
            ScanExecutor executor = new ScanExecutor(policy, namespace, setName, callback);
            executor.scanParallel(nodes);
        } else {
            for (Node node : nodes) {
                this.scanNode(policy, node, namespace, setName, callback);
            }
        }
    }

    public final void scanNode(ScanPolicy policy, String nodeName, String namespace, String setName, ScanCallback callback) throws AerospikeException {
        Node node = this.cluster.getNode(nodeName);
        this.scanNode(policy, node, namespace, setName, callback);
    }

    public final void scanNode(ScanPolicy policy, Node node, String namespace, String setName, ScanCallback callback) throws AerospikeException {
        if (policy == null) {
            policy = new ScanPolicy();
        }
        policy.maxRetries = 0;
        ScanCommand command = new ScanCommand(node, callback);
        command.setScan(policy, namespace, setName);
        command.execute(policy);
    }

    public final LargeSet getLargeSet(Policy policy, Key key, String binName) {
        return new LargeSet(this, policy, key, binName);
    }

    public final LargeStack getLargeStack(Policy policy, Key key, String binName) {
        return new LargeStack(this, policy, key, binName);
    }

    public final void register(Policy policy, String clientPath, String serverPath, Language language) throws AerospikeException {
        String content = Util.readFileEncodeBase64(clientPath);
        StringBuilder sb = new StringBuilder(serverPath.length() + content.length() + 100);
        sb.append("udf-put:filename=");
        sb.append(serverPath);
        sb.append(";content=");
        sb.append(content);
        sb.append(";content-len=");
        sb.append(content.length());
        sb.append(";udf-type=");
        sb.append(language.id);
        sb.append(";");
        String command = sb.toString();
        Node[] nodes = this.cluster.getNodes();
        int timeout = policy == null ? 0 : policy.timeout;
        for (Node node : nodes) {
            Info info = new Info(node.getConnection(timeout), command);
            Info.NameValueParser parser = info.getNameValueParser();
            while (parser.next()) {
                String name = parser.getName();
                if (!name.equals("error")) continue;
                throw new AerospikeException(serverPath + " registration failed: " + parser.getValue());
            }
        }
    }

    public final Object execute(Policy policy, Key key, String packageName, String functionName, Value ... args) throws AerospikeException {
        ReadCommand command = new ReadCommand(this.cluster, key);
        command.setUdf(key, packageName, functionName, args);
        command.execute(policy);
        Record record = command.getRecord();
        if (record == null || record.bins == null) {
            return null;
        }
        Map<String, Object> map = record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }

    public final RecordSet query(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = new QueryPolicy();
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(policy, statement, this.cluster.getNodes());
        return executor.getRecordSet();
    }

    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = new QueryPolicy();
        }
        QueryAggregateExecutor executor = new QueryAggregateExecutor(policy, statement, this.cluster.getNodes(), packageName, functionName, functionArgs);
        return executor.getResultSet();
    }

    public final void createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType) throws AerospikeException {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-create:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        sb.append(";numbins=1");
        sb.append(";indexdata=");
        sb.append(binName);
        sb.append(",");
        sb.append((Object)indexType);
        sb.append(";priority=normal");
        String command = sb.toString();
        Node[] nodes = this.cluster.getNodes();
        int timeout = policy == null ? 0 : policy.timeout;
        for (Node node : nodes) {
            Info info = new Info(node.getConnection(timeout), command);
            String response = info.getValue();
            if (response.equalsIgnoreCase("OK") || response.equals("FAIL:208:ERR FOUND")) continue;
            throw new AerospikeException("Create index failed: " + response);
        }
    }

    public final void dropIndex(Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-delete:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        String command = sb.toString();
        Node[] nodes = this.cluster.getNodes();
        int timeout = policy == null ? 0 : policy.timeout;
        for (Node node : nodes) {
            Info info = new Info(node.getConnection(timeout), command);
            String response = info.getValue();
            if (response.equalsIgnoreCase("ok") || response.equals("FAIL:202:NO INDEX")) continue;
            throw new AerospikeException("Drop index failed: " + response);
        }
    }

    protected static HashSet<String> binNamesToHashSet(String[] binNames) {
        HashSet<String> names = new HashSet<String>(binNames.length);
        for (String binName : binNames) {
            names.add(binName);
        }
        return names;
    }
}

