/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.LargeStack;
import com.aerospike.client.Value;
import com.aerospike.client.policy.Policy;
import java.util.List;
import java.util.Map;

public final class LargeSet {
    private static final String Filename = "LSET";
    private final AerospikeClient client;
    private final Policy policy;
    private final Key key;
    private final Value binName;

    public LargeSet(AerospikeClient client, Policy policy, Key key, String binName) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
    }

    public final void create(String configName) throws AerospikeException {
        Value configValue = LargeStack.getConfigValue(configName);
        this.client.execute(this.policy, this.key, Filename, "lset_create", this.binName, configValue);
    }

    public final void insert(String configName, Value value) throws AerospikeException {
        Value configValue = LargeStack.getConfigValue(configName);
        this.client.execute(this.policy, this.key, Filename, "lset_create_and_insert", this.binName, value, configValue);
    }

    public final void insert(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, Filename, "lset_insert", this.binName, value);
    }

    public final void delete(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, Filename, "lset_delete", this.binName, value);
    }

    public final List<?> search(Value value) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, Filename, "lset_search", this.binName, value, Value.get(0));
    }

    public final List<?> search(Value value, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, Filename, "lset_search_then_filter", this.binName, value, Value.get(0), Value.get(filterName), Value.get(filterArgs));
    }

    public final int size() throws AerospikeException {
        return (Integer)this.client.execute(this.policy, this.key, Filename, "lset_size", this.binName);
    }

    public final Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, Filename, "lset_config", this.binName);
    }
}

