/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.Bin;
import com.aerospike.client.Value;

public final class Operation {
    public final Type type;
    public final String binName;
    public final Value binValue;

    public static Operation get(String binName) {
        return new Operation(Type.READ, binName);
    }

    public static Operation get() {
        return new Operation(Type.READ);
    }

    public static Operation getHeader() {
        return new Operation(Type.READ_HEADER);
    }

    public static Operation put(Bin bin) {
        return new Operation(Type.WRITE, bin);
    }

    public static Operation append(Bin bin) {
        return new Operation(Type.APPEND, bin);
    }

    public static Operation prepend(Bin bin) {
        return new Operation(Type.PREPEND, bin);
    }

    public static Operation add(Bin bin) {
        return new Operation(Type.ADD, bin);
    }

    public static Operation touch() {
        return new Operation(Type.TOUCH);
    }

    private Operation(Type type, Bin bin) {
        this.type = type;
        this.binName = bin.name;
        this.binValue = bin.value;
    }

    private Operation(Type type, String binName) {
        this.type = type;
        this.binName = binName;
        this.binValue = Value.getAsNull();
    }

    private Operation(Type type) {
        this.type = type;
        this.binName = null;
        this.binValue = Value.getAsNull();
    }

    public static enum Type {
        READ(1),
        READ_HEADER(1),
        WRITE(2),
        ADD(5),
        APPEND(9),
        PREPEND(10),
        TOUCH(11);

        public final int protocolType;

        private Type(int protocolType) {
            this.protocolType = protocolType;
        }
    }
}

