/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaList;
import com.aerospike.client.lua.LuaMap;
import com.aerospike.client.util.MsgPack;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.msgpack.packer.Packer;

public abstract class Value {
    public static Value get(String value) {
        return value == null ? new NullValue() : new StringValue(value);
    }

    public static Value get(byte[] value) {
        return value == null ? new NullValue() : new BytesValue(value);
    }

    public static Value get(int value) {
        return new IntegerValue(value);
    }

    public static Value get(long value) {
        return new LongValue(value);
    }

    public static Value get(Value[] value) {
        return new ValueArray(value);
    }

    public static Value getAsBlob(Object value) {
        return value == null ? new NullValue() : new BlobValue(value);
    }

    public static Value getAsList(List<?> value) {
        return value == null ? new NullValue() : new ListValue(value);
    }

    public static Value getAsMap(Map<?, ?> value) {
        return value == null ? new NullValue() : new MapValue(value);
    }

    public static Value getAsNull() {
        return new NullValue();
    }

    public static Value get(Object value) {
        if (value == null) {
            return new NullValue();
        }
        if (value instanceof String) {
            return new StringValue((String)value);
        }
        if (value instanceof byte[]) {
            return new BytesValue((byte[])value);
        }
        if (value instanceof Integer) {
            return new IntegerValue((Integer)value);
        }
        if (value instanceof Long) {
            return new LongValue((Long)value);
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        return new BlobValue(value);
    }

    public abstract int estimateSize() throws AerospikeException;

    public abstract int write(byte[] var1, int var2) throws AerospikeException;

    public abstract void pack(Packer var1) throws IOException;

    public abstract int getType();

    public abstract Object getObject();

    public abstract LuaValue getLuaValue();

    public static final class MapValue
    extends Value {
        private final Map<?, ?> map;
        private byte[] bytes;

        public MapValue(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = MsgPack.pack(this.map);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            MsgPack.packMap(packer, this.map);
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public Object getObject() {
            return this.map;
        }

        @Override
        public LuaValue getLuaValue() {
            return new LuaMap(this.map);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static final class ListValue
    extends Value {
        private final List<?> list;
        private byte[] bytes;

        public ListValue(List<?> list) {
            this.list = list;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = MsgPack.pack(this.list);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            MsgPack.packList(packer, this.list);
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.list;
        }

        @Override
        public LuaValue getLuaValue() {
            return new LuaList(this.list);
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public static final class ValueArray
    extends Value {
        private final Value[] array;
        private byte[] bytes;

        public ValueArray(Value[] array) {
            this.array = array;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = MsgPack.pack(this.array);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            MsgPack.packValueArray(packer, this.array);
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.array;
        }

        @Override
        public LuaValue getLuaValue() {
            return null;
        }

        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    public static final class BlobValue
    extends Value {
        private final Object object;
        private byte[] bytes;

        public BlobValue(Object object) {
            this.object = object;
        }

        @Override
        public int estimateSize() throws AerospikeException.Serialize {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                ObjectOutputStream ostream = new ObjectOutputStream(bstream);
                ostream.writeObject(this.object);
                ostream.close();
                this.bytes = bstream.toByteArray();
                return this.bytes.length;
            }
            catch (Exception e) {
                throw new AerospikeException.Serialize(e);
            }
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            MsgPack.packBlob(packer, this.object);
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public LuaValue getLuaValue() {
            return LuaString.valueOf((byte[])this.bytes);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes);
        }
    }

    public static final class LongValue
    extends Value {
        private final long value;

        public LongValue(long value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.write(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue() {
            return LuaInteger.valueOf((long)this.value);
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    public static final class IntegerValue
    extends Value {
        private final int value;

        public IntegerValue(int value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.write(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue() {
            return LuaInteger.valueOf((int)this.value);
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static final class StringValue
    extends Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return Buffer.estimateSizeUtf8(this.value);
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return Buffer.stringToUtf8(this.value, buffer, offset);
        }

        @Override
        public void pack(Packer packer) throws IOException {
            MsgPack.packString(packer, this.value);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue() {
            return LuaString.valueOf((String)this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    public static final class BytesValue
    extends Value {
        private final byte[] bytes;

        public BytesValue(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int estimateSize() {
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            MsgPack.packBytes(packer, this.bytes);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public Object getObject() {
            return this.bytes;
        }

        @Override
        public LuaValue getLuaValue() {
            return LuaString.valueOf((byte[])this.bytes);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes);
        }
    }

    public static final class NullValue
    extends Value {
        @Override
        public int estimateSize() {
            return 0;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return 0;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.writeNil();
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public LuaValue getLuaValue() {
            return LuaNil.NIL;
        }

        public String toString() {
            return null;
        }
    }
}

