/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.Buffer;
import java.util.HashMap;
import java.util.HashSet;

public final class AsyncBatchGetArray
extends AsyncMultiCommand {
    private final HashMap<Key, BatchItem> keyMap;
    private final Record[] records;

    public AsyncBatchGetArray(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, HashMap<Key, BatchItem> keyMap, HashSet<String> binNames, Record[] records) {
        super(parent, cluster, node, binNames);
        this.keyMap = keyMap;
        this.records = records;
    }

    @Override
    protected void parseRow(Key key) throws AerospikeException {
        BatchItem item = this.keyMap.get(key);
        if (item != null) {
            if (this.resultCode == 0) {
                int index2 = item.getIndex();
                this.records[index2] = this.parseRecordWithDuplicates();
            }
        } else if (Log.debugEnabled()) {
            Log.debug("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest));
        }
    }
}

