/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncBatchGetArray;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Command;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.policy.Policy;
import java.util.HashMap;
import java.util.HashSet;

public final class AsyncBatchGetArrayExecutor
extends AsyncBatchExecutor {
    private final RecordArrayListener listener;
    private final Record[] recordArray;

    public AsyncBatchGetArrayExecutor(AsyncCluster cluster, Policy policy, RecordArrayListener listener, Key[] keys2, HashSet<String> binNames, int readAttr) throws AerospikeException {
        super(cluster, keys2);
        this.recordArray = new Record[keys2.length];
        this.listener = listener;
        HashMap<Key, BatchItem> keyMap = BatchItem.generateMap(keys2);
        for (BatchNode batchNode : this.batchNodes) {
            for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                Command command = new Command();
                command.setBatchGet(batchNamespace, binNames, readAttr);
                AsyncBatchGetArray async = new AsyncBatchGetArray(this, cluster, (AsyncNode)batchNode.node, keyMap, binNames, this.recordArray);
                async.execute(policy, command);
            }
        }
    }

    @Override
    protected void onSuccess() {
        this.listener.onSuccess(this.keys, this.recordArray);
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.listener.onFailure(ae);
    }
}

