/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.cluster.Partition;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AsyncSingleCommand
extends AsyncCommand {
    protected final Key key;
    private final Partition partition;
    protected int receiveSize;
    private boolean inHeader = true;

    public AsyncSingleCommand(AsyncCluster cluster, Key key) {
        super(cluster);
        this.key = key;
        this.partition = new Partition(key);
    }

    @Override
    protected final AsyncNode getNode() throws AerospikeException.InvalidNode {
        return (AsyncNode)this.cluster.getNode(this.partition);
    }

    @Override
    protected final void read() throws AerospikeException, IOException {
        if (this.inHeader) {
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            this.byteBuffer.position(0);
            this.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
            if (this.receiveSize <= this.byteBuffer.capacity()) {
                this.byteBuffer.clear();
                this.byteBuffer.limit(this.receiveSize);
            } else {
                this.byteBuffer = ByteBuffer.allocateDirect(this.receiveSize);
            }
            this.inHeader = false;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        this.parseResult(this.byteBuffer);
        this.finish();
    }

    protected abstract void parseResult(ByteBuffer var1) throws AerospikeException;
}

