/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public final class Connection {
    private final Socket socket;
    private InputStream in;
    private OutputStream out;
    private final long maxSocketIdleMillis;
    private long lastUsed;

    public Connection(InetSocketAddress address, int timeoutMillis) throws AerospikeException.Connection {
        this(address, timeoutMillis, 14);
    }

    public Connection(InetSocketAddress address, int timeoutMillis, int maxSocketIdleSeconds) throws AerospikeException.Connection {
        this.maxSocketIdleMillis = (long)maxSocketIdleSeconds * 1000L;
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(timeoutMillis);
            this.socket.connect(address, timeoutMillis);
            this.lastUsed = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new AerospikeException.Connection(e);
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isValid() {
        return this.socket.isConnected() && System.currentTimeMillis() - this.lastUsed <= this.maxSocketIdleMillis;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public InputStream getInputStream() throws IOException {
        this.in = this.socket.getInputStream();
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        this.out = this.socket.getOutputStream();
        return this.out;
    }

    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public void close() {
        block4: {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                this.socket.close();
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) break block4;
                Log.debug("Error closing socket: " + Util.getErrorMessage(e));
            }
        }
    }
}

