/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.util.Util;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class NodeValidator {
    String name;
    Host[] aliases;
    InetSocketAddress address;

    public NodeValidator(Host host, int timeoutMillis) throws AerospikeException {
        this.setAliases(host);
        this.setAddress(timeoutMillis);
    }

    private void setAliases(Host host) throws AerospikeException {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host.name);
            int count = 0;
            this.aliases = new Host[addresses.length];
            for (InetAddress address : addresses) {
                this.aliases[count++] = new Host(address.getHostAddress(), host.port);
            }
        }
        catch (UnknownHostException uhe) {
            throw new AerospikeException.Connection("Invalid host: " + host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAddress(int timeoutMillis) throws AerospikeException {
        for (Host alias : this.aliases) {
            try {
                InetSocketAddress address = new InetSocketAddress(alias.name, alias.port);
                Connection conn = new Connection(address, timeoutMillis);
                try {
                    String nodeName = Info.request(conn, "node");
                    if (nodeName == null) continue;
                    this.name = nodeName;
                    this.address = address;
                    return;
                }
                finally {
                    conn.close();
                }
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) continue;
                Log.debug("Alias " + alias + " failed: " + Util.getErrorMessage(e));
            }
        }
        throw new AerospikeException.Connection("Failed to connect to host aliases: " + Arrays.toString(this.aliases));
    }
}

