/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import java.io.IOException;
import java.util.HashMap;

public final class BatchCommandExists
extends MultiCommand {
    private final HashMap<Key, BatchItem> keyMap;
    private final boolean[] existsArray;

    public BatchCommandExists(Node node, HashMap<Key, BatchItem> keyMap, boolean[] existsArray) {
        super(node);
        this.keyMap = keyMap;
        this.existsArray = existsArray;
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.receiveOffset = 0;
        while (this.receiveOffset < receiveSize) {
            this.readBytes(22);
            byte resultCode = this.receiveBuffer[5];
            if (resultCode != 0 && resultCode != 2) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.receiveBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int fieldCount = Buffer.bytesToShort(this.receiveBuffer, 18);
            int opCount = Buffer.bytesToShort(this.receiveBuffer, 20);
            if (opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            Key key = this.parseKey(fieldCount);
            BatchItem item = this.keyMap.get(key);
            if (item != null) {
                int index2 = item.getIndex();
                this.existsArray[index2] = resultCode == 0;
                continue;
            }
            if (!Log.debugEnabled()) continue;
            Log.debug("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest));
        }
        return true;
    }
}

