/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.Key;
import java.util.ArrayList;
import java.util.HashMap;

public final class BatchItem {
    private int index;
    private ArrayList<Integer> duplicates;

    public static HashMap<Key, BatchItem> generateMap(Key[] keys2) {
        HashMap<Key, BatchItem> keyMap = new HashMap<Key, BatchItem>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            Key key = keys2[i];
            BatchItem item = keyMap.get(key);
            if (item == null) {
                item = new BatchItem(i);
                keyMap.put(key, item);
                continue;
            }
            item.addDuplicate(i);
        }
        return keyMap;
    }

    public BatchItem(int idx) {
        this.index = idx;
    }

    public void addDuplicate(int idx) {
        if (this.duplicates == null) {
            this.duplicates = new ArrayList();
            this.duplicates.add(this.index);
            this.index = 0;
        }
        this.duplicates.add(idx);
    }

    public int getIndex() {
        return this.duplicates == null ? this.index : this.duplicates.get(this.index++);
    }
}

