/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class MultiCommand
extends SyncCommand {
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private BufferedInputStream bis;
    protected final Node node;
    protected int receiveOffset;

    protected MultiCommand(Node node) {
        this.node = node;
        this.receiveBuffer = new byte[2048];
    }

    @Override
    protected final Node getNode() {
        return this.node;
    }

    protected final void writeHeader(int readAttr, int fieldCount, int operationCount) throws AerospikeException {
        this.sendBuffer[8] = 22;
        this.sendBuffer[9] = (byte)readAttr;
        for (int i = 10; i < 26; ++i) {
            this.sendBuffer[i] = 0;
        }
        Buffer.shortToBytes(fieldCount, this.sendBuffer, 26);
        Buffer.shortToBytes(operationCount, this.sendBuffer, 28);
        this.sendOffset = 30;
    }

    @Override
    protected final void parseResult(InputStream is) throws AerospikeException, IOException {
        this.bis = new BufferedInputStream(is);
        boolean status = true;
        while (status) {
            this.readBytes(8);
            long size = Buffer.bytesToLong(this.receiveBuffer, 0);
            int receiveSize = (int)(size & 0xFFFFFFFFFFFFL);
            if (receiveSize > 0) {
                status = this.parseRecordResults(receiveSize);
                continue;
            }
            status = false;
        }
    }

    protected final Key parseKey(int fieldCount) throws IOException {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        for (int i = 0; i < fieldCount; ++i) {
            this.readBytes(4);
            int fieldlen = Buffer.bytesToInt(this.receiveBuffer, 0);
            this.readBytes(fieldlen);
            byte fieldtype = this.receiveBuffer[0];
            int size = fieldlen - 1;
            if (fieldtype == 4) {
                digest = new byte[size];
                System.arraycopy(this.receiveBuffer, 1, digest, 0, size);
                continue;
            }
            if (fieldtype == 0) {
                namespace = new String(this.receiveBuffer, 1, size);
                continue;
            }
            if (fieldtype != 1) continue;
            setName = new String(this.receiveBuffer, 1, size);
        }
        return new Key(namespace, digest, setName);
    }

    protected final void readBytes(int length) throws IOException {
        int count;
        if (length > this.receiveBuffer.length) {
            if (length > 0xA00000) {
                throw new IllegalArgumentException("Invalid readBytes length: " + length);
            }
            this.receiveBuffer = new byte[length];
        }
        for (int pos = 0; pos < length; pos += count) {
            count = this.bis.read(this.receiveBuffer, pos, length - pos);
            if (count >= 0) continue;
            throw new EOFException();
        }
        this.receiveOffset += length;
    }

    protected abstract boolean parseRecordResults(int var1) throws AerospikeException, IOException;
}

