/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SingleCommand;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReadCommand
extends SingleCommand {
    private Record record;
    private int resultCode;

    public ReadCommand(Cluster cluster, Key key) {
        super(cluster, key);
    }

    @Override
    protected void parseResult(InputStream is) throws AerospikeException, IOException {
        ReadCommand.readFully(is, this.receiveBuffer, 30);
        long sz = Buffer.bytesToLong(this.receiveBuffer, 0);
        byte headerLength = this.receiveBuffer[8];
        this.resultCode = this.receiveBuffer[13];
        int generation = Buffer.bytesToInt(this.receiveBuffer, 14);
        int expiration = Buffer.bytesToInt(this.receiveBuffer, 18);
        int fieldCount = Buffer.bytesToShort(this.receiveBuffer, 26);
        int opCount = Buffer.bytesToShort(this.receiveBuffer, 28);
        int receiveSize = (int)(sz & 0xFFFFFFFFFFFFL) - headerLength;
        if (receiveSize > 0) {
            this.resizeReceiveBuffer(receiveSize);
            ReadCommand.readFully(is, this.receiveBuffer, receiveSize);
        }
        if (this.resultCode != 0) {
            if (this.resultCode == 2) {
                return;
            }
            throw new AerospikeException(this.resultCode);
        }
        if (opCount == 0) {
            this.record = new Record(null, null, generation, expiration);
            return;
        }
        this.record = this.parseRecord(opCount, fieldCount, generation, expiration);
    }

    private final Record parseRecord(int opCount, int fieldCount, int generation, int expiration) throws AerospikeException {
        int i;
        HashMap<String, Object> bins = null;
        ArrayList<HashMap<String, Object>> duplicates = null;
        int receiveOffset = 0;
        if (fieldCount != 0) {
            for (i = 0; i < fieldCount; ++i) {
                int fieldSize = Buffer.bytesToInt(this.receiveBuffer, receiveOffset);
                receiveOffset += 4 + fieldSize;
            }
        }
        for (i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.receiveBuffer, receiveOffset);
            byte particleType = this.receiveBuffer[receiveOffset + 5];
            int version = this.receiveBuffer[receiveOffset + 6];
            byte nameSize = this.receiveBuffer[receiveOffset + 7];
            String name = Buffer.utf8ToString(this.receiveBuffer, receiveOffset + 8, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = null;
            value = Buffer.bytesToParticle(particleType, this.receiveBuffer, receiveOffset += 8 + nameSize, particleBytesSize);
            receiveOffset += particleBytesSize;
            Map<String, Object> vmap = null;
            if (version > 0 || duplicates != null) {
                int j;
                if (duplicates == null) {
                    duplicates = new ArrayList<HashMap<String, Object>>(4);
                    duplicates.add(bins);
                    bins = null;
                    for (j = 0; j < version; ++j) {
                        duplicates.add(null);
                    }
                } else {
                    for (j = duplicates.size(); j < version + 1; ++j) {
                        duplicates.add(null);
                    }
                }
                if ((vmap = (Map)duplicates.get(version)) == null) {
                    vmap = new HashMap();
                    duplicates.set(version, (HashMap<String, Object>)vmap);
                }
            } else {
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                vmap = bins;
            }
            vmap.put(name, value);
        }
        if (duplicates != null) {
            while (duplicates.remove(null)) {
            }
        }
        return new Record(bins, (List<Map<String, Object>>)duplicates, generation, expiration);
    }

    public Record getRecord() {
        return this.record;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

