/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.policy.ScanPolicy;

public final class ScanExecutor {
    private final ScanPolicy policy;
    private final String namespace;
    private final String setName;
    private final ScanCallback callback;
    private ScanThread[] threads;
    private Exception exception;

    public ScanExecutor(ScanPolicy policy, String namespace, String setName, ScanCallback callback) {
        this.policy = policy;
        this.namespace = namespace;
        this.setName = setName;
        this.callback = callback;
    }

    public void scanParallel(Node[] nodes) throws AerospikeException {
        this.threads = new ScanThread[nodes.length];
        int count = 0;
        for (Node node : nodes) {
            ScanCommand command = new ScanCommand(node, this.callback);
            ScanThread thread = new ScanThread(command);
            this.threads[count++] = thread;
            thread.start();
        }
        for (ScanThread thread : this.threads) {
            try {
                thread.join();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(Exception cause) {
        ScanExecutor scanExecutor = this;
        synchronized (scanExecutor) {
            if (this.exception != null) {
                return;
            }
            this.exception = cause;
        }
        for (ScanThread thread : this.threads) {
            try {
                thread.stopThread();
                thread.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private final class ScanThread
    extends Thread {
        private final ScanCommand command;

        public ScanThread(ScanCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.setScan(ScanExecutor.this.policy, ScanExecutor.this.namespace, ScanExecutor.this.setName);
                this.command.execute(ScanExecutor.this.policy);
            }
            catch (Exception e) {
                ScanExecutor.this.stopThreads(e);
            }
        }

        public void stopThread() {
            this.command.stop();
        }
    }
}

