/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaConfig;
import com.aerospike.client.lua.LuaInstance;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.DumpState;
import org.luaj.vm2.compiler.LuaC;

public final class LuaCache {
    private static final ArrayBlockingQueue<LuaInstance> InstanceQueue = new ArrayBlockingQueue(LuaConfig.InstancePoolSize);
    private static final ConcurrentHashMap<String, Prototype> Packages = new ConcurrentHashMap();

    public static final LuaInstance getInstance() throws IOException {
        LuaInstance instance = InstanceQueue.poll();
        return instance != null ? instance : new LuaInstance();
    }

    public static final void putInstance(LuaInstance instance) {
        InstanceQueue.offer(instance);
    }

    public static final Prototype loadPackage(String packageName) throws IOException {
        Prototype prototype = Packages.get(packageName);
        if (prototype == null) {
            prototype = LuaCache.loadOrCompilePackage(packageName);
            Packages.put(packageName, prototype);
        }
        return prototype;
    }

    private static Prototype loadOrCompilePackage(String packageName) throws IOException {
        File source = new File(LuaConfig.SourceDirectory, packageName + ".lua");
        File target = new File(LuaConfig.SourceDirectory, packageName + ".out");
        long sourceLastModified = source.lastModified();
        long targetLastModified = target.lastModified();
        if (sourceLastModified == 0L && targetLastModified == 0L) {
            throw new FileNotFoundException("Failed to read " + source.getAbsolutePath());
        }
        if (sourceLastModified > targetLastModified) {
            return LuaCache.compile(packageName, source, target);
        }
        return LuaCache.loadCompiled(target, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Prototype compile(String packageName, File source, File target) throws IOException {
        boolean littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        try {
            Prototype prototype = LuaC.compile((InputStream)is, (String)packageName);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(target));
            try {
                DumpState.dump((Prototype)prototype, (OutputStream)os, (boolean)true, (int)0, (boolean)littleEndian);
            }
            finally {
                os.close();
            }
            Prototype prototype2 = prototype;
            return prototype2;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Prototype loadCompiled(File file, String packageName) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            int firstByte = is.read();
            if (firstByte != 27) {
                throw new IOException("Invalid lua byte code");
            }
            Prototype prototype = LoadState.loadBinaryChunk((int)firstByte, (InputStream)is, (String)packageName);
            prototype.source = LuaString.valueOf((String)packageName);
            Prototype prototype2 = prototype;
            return prototype2;
        }
        finally {
            is.close();
        }
    }

    public static final void clearPackages() {
        Packages.clear();
    }
}

