/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.Log;
import com.aerospike.client.Value;
import com.aerospike.client.lua.LuaCache;
import com.aerospike.client.lua.LuaInputStream;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaOutputStream;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Util;
import java.util.concurrent.BlockingQueue;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaValue;

public final class LuaExecutor
implements Runnable {
    private final Statement statement;
    private final BlockingQueue<LuaValue> inputQueue;
    private final ResultSet resultSet;

    public LuaExecutor(Statement statement, BlockingQueue<LuaValue> inputQueue, ResultSet resultSet) {
        this.statement = statement;
        this.inputQueue = inputQueue;
        this.resultSet = resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block6: {
            try {
                LuaInstance lua = LuaCache.getInstance();
                try {
                    lua.load(this.statement.getPackageName());
                    LuaValue[] args = new LuaValue[4 + this.statement.getFunctionArgs().length];
                    args[0] = lua.getFunction(this.statement.getFunctionName());
                    args[1] = LuaInteger.valueOf((int)2);
                    args[2] = new LuaInputStream(this.inputQueue);
                    args[3] = new LuaOutputStream(this.resultSet);
                    int count = 4;
                    for (Value value : this.statement.getFunctionArgs()) {
                        args[count++] = value.getLuaValue();
                    }
                    lua.call("apply_stream", args);
                }
                finally {
                    LuaCache.putInstance(lua);
                }
            }
            catch (Exception e) {
                if (!Log.infoEnabled()) break block6;
                Log.info("Lua error: " + Util.getErrorMessage(e));
            }
        }
    }
}

