/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaList;
import com.aerospike.client.lua.LuaUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public final class LuaListLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaListLib(LuaInstance instance) {
        this.instance = instance;
        instance.load((LibFunction)new MetaLib(instance));
    }

    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 8);
        table.setmetatable((LuaValue)meta);
        table.set("size", (LuaValue)new len());
        table.set("iterator", (LuaValue)new iterator());
        table.set("append", (LuaValue)new append());
        table.set("prepend", (LuaValue)new prepend());
        table.set("take", (LuaValue)new take());
        table.set("drop", (LuaValue)new drop());
        table.set("tostring", (LuaValue)new tostring());
        this.instance.registerPackage("list", table);
        return table;
    }

    public static final class newindex
    extends ThreeArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            LuaList list = (LuaList)arg1;
            int index2 = arg2.toint();
            list.ensureSize(index2);
            list.setValue(index2 - 1, arg3);
            return NIL;
        }
    }

    public static final class index
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaList list = (LuaList)arg1;
            return list.getValue(arg2);
        }
    }

    public static final class tostring
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaList list = (LuaList)arg;
            return LuaString.valueOf((String)list.list.toString());
        }
    }

    public static final class len
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaList list = (LuaList)arg;
            return LuaInteger.valueOf((int)list.list.size());
        }
    }

    public static final class drop
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaList list = (LuaList)arg1;
            return list.drop(arg2);
        }
    }

    public static final class take
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaList list = (LuaList)arg1;
            return list.take(arg2);
        }
    }

    public static final class prepend
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaList list = (LuaList)arg1;
            list.append(0, arg2);
            return NIL;
        }
    }

    public static final class append
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaList list = (LuaList)arg1;
            list.append(arg2);
            return NIL;
        }
    }

    public static final class nextObject
    extends ZeroArgFunction {
        private final Iterator<?> iter;

        public nextObject(Iterator<?> iter) {
            this.iter = iter;
        }

        public LuaValue call() {
            if (this.iter.hasNext()) {
                Object obj = this.iter.next();
                return LuaUtil.objectToLua(obj);
            }
            return NIL;
        }
    }

    public static final class nextLuaValue
    extends ZeroArgFunction {
        private final Iterator<LuaValue> iter;

        public nextLuaValue(Iterator<LuaValue> iter) {
            this.iter = iter;
        }

        public LuaValue call() {
            return this.iter.hasNext() ? this.iter.next() : LuaValue.NIL;
        }
    }

    public static final class iterator
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaList list = (LuaList)arg;
            if (list instanceof LuaList.LuaValueList) {
                return new nextLuaValue(list.list.iterator());
            }
            return new nextObject(list.list.iterator());
        }
    }

    public static final class create
    extends VarArgFunction {
        private final LuaValue meta;

        public create(LuaInstance instance) {
            this.meta = instance.getPackage("List");
        }

        public Varargs invoke(Varargs args) {
            LuaList.LuaValueList list = new LuaList.LuaValueList((List<LuaValue>)new ArrayList<LuaValue>());
            list.setmetatable(this.meta);
            if (args.istable(2)) {
                Varargs n;
                LuaTable table = args.checktable(2);
                LuaValue k = LuaValue.NIL;
                while (!(k = (n = table.next(k)).arg1()).isnil()) {
                    LuaValue v = n.arg(2);
                    list.append(v);
                }
            }
            return LuaValue.varargsOf((LuaValue[])new LuaValue[]{list});
        }
    }

    public static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            meta.set("__len", (LuaValue)new len());
            meta.set("__tostring", (LuaValue)new tostring());
            meta.set("__index", (LuaValue)new index());
            meta.set("__newindex", (LuaValue)new newindex());
            this.instance.registerPackage("List", meta);
            return meta;
        }
    }
}

