/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaListLib;
import com.aerospike.client.lua.LuaMap;
import com.aerospike.client.lua.LuaUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public final class LuaMapLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaMapLib(LuaInstance instance) {
        this.instance = instance;
        instance.load((LibFunction)new MetaLib(instance));
    }

    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 8);
        table.setmetatable((LuaValue)meta);
        table.set("size", (LuaValue)new len());
        iterator iter = new iterator();
        table.set("iterator", (LuaValue)iter);
        table.set("pairs", (LuaValue)iter);
        table.set("keys", (LuaValue)new keys());
        table.set("values", (LuaValue)new values());
        table.set("tostring", (LuaValue)new tostring());
        this.instance.registerPackage("map", table);
        return table;
    }

    public static final class newindex
    extends ThreeArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            LuaMap map = (LuaMap)arg1;
            map.setValue(arg2, arg3);
            return NIL;
        }
    }

    public static final class index
    extends TwoArgFunction {
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            LuaMap map = (LuaMap)arg1;
            return map.getValue(arg2);
        }
    }

    public static final class tostring
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            return LuaString.valueOf((String)map.map.toString());
        }
    }

    public static final class len
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            return LuaInteger.valueOf((int)map.map.size());
        }
    }

    public static final class values
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            if (map instanceof LuaMap.LuaValueMap) {
                LuaMap.LuaValueMap lmap = (LuaMap.LuaValueMap)map;
                return new LuaListLib.nextLuaValue(lmap.map.values().iterator());
            }
            return new LuaListLib.nextObject(map.map.values().iterator());
        }
    }

    public static final class keys
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            if (map instanceof LuaMap.LuaValueMap) {
                LuaMap.LuaValueMap lmap = (LuaMap.LuaValueMap)map;
                return new LuaListLib.nextLuaValue(lmap.map.keySet().iterator());
            }
            return new LuaListLib.nextObject(map.map.keySet().iterator());
        }
    }

    public static final class nextObject
    extends VarArgFunction {
        private final Iterator iter;

        public nextObject(Iterator iter) {
            this.iter = iter;
        }

        public Varargs invoke(Varargs args) {
            if (this.iter.hasNext()) {
                Map.Entry entry = (Map.Entry)this.iter.next();
                LuaValue key = LuaUtil.objectToLua(entry.getKey());
                LuaValue value = LuaUtil.objectToLua(entry.getValue());
                return LuaValue.varargsOf((LuaValue[])new LuaValue[]{key, value});
            }
            return NONE;
        }
    }

    public static final class nextLuaValue
    extends VarArgFunction {
        private final Iterator<Map.Entry<LuaValue, LuaValue>> iter;

        public nextLuaValue(Iterator<Map.Entry<LuaValue, LuaValue>> iter) {
            this.iter = iter;
        }

        public Varargs invoke(Varargs args) {
            if (this.iter.hasNext()) {
                Map.Entry<LuaValue, LuaValue> entry = this.iter.next();
                return LuaValue.varargsOf((LuaValue[])new LuaValue[]{entry.getKey(), entry.getValue()});
            }
            return NONE;
        }
    }

    public static final class iterator
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            if (map instanceof LuaMap.LuaValueMap) {
                LuaMap.LuaValueMap lmap = (LuaMap.LuaValueMap)map;
                return new nextLuaValue(lmap.map.entrySet().iterator());
            }
            return new nextObject(map.map.entrySet().iterator());
        }
    }

    public static final class create
    extends VarArgFunction {
        private final LuaValue meta;

        public create(LuaInstance instance) {
            this.meta = instance.getPackage("Map");
        }

        public Varargs invoke(Varargs args) {
            LuaMap.LuaValueMap map = new LuaMap.LuaValueMap((Map<LuaValue, LuaValue>)new HashMap<LuaValue, LuaValue>());
            map.setmetatable(this.meta);
            if (args.istable(2)) {
                Varargs n;
                LuaTable table = args.checktable(2);
                LuaValue k = LuaValue.NIL;
                while (!(k = (n = table.next(k)).arg1()).isnil()) {
                    LuaValue v = n.arg(2);
                    map.setValue(k, v);
                }
            }
            return LuaValue.varargsOf((LuaValue[])new LuaValue[]{map});
        }
    }

    public static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            meta.set("__len", (LuaValue)new len());
            meta.set("__tostring", (LuaValue)new tostring());
            meta.set("__index", (LuaValue)new index());
            meta.set("__newindex", (LuaValue)new newindex());
            this.instance.registerPackage("Map", meta);
            return meta;
        }
    }
}

