/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.query.QueryCommand;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.luaj.vm2.LuaValue;

public final class QueryAggregateCommand
extends QueryCommand {
    private final BlockingQueue<LuaValue> inputQueue;

    public QueryAggregateCommand(Node node, BlockingQueue<LuaValue> inputQueue) {
        super(node);
        this.inputQueue = inputQueue;
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.receiveOffset = 0;
        while (this.receiveOffset < receiveSize) {
            this.readBytes(22);
            byte resultCode = this.receiveBuffer[5];
            if (resultCode != 0) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.receiveBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int fieldCount = Buffer.bytesToShort(this.receiveBuffer, 18);
            int opCount = Buffer.bytesToShort(this.receiveBuffer, 20);
            this.parseKey(fieldCount);
            if (opCount != 1) {
                throw new AerospikeException("Query aggregate expected exactly one bin.  Received " + opCount);
            }
            this.readBytes(8);
            int opSize = Buffer.bytesToInt(this.receiveBuffer, 0);
            byte particleType = this.receiveBuffer[5];
            byte nameSize = this.receiveBuffer[7];
            this.readBytes(nameSize);
            String name = Buffer.utf8ToString(this.receiveBuffer, 0, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            this.readBytes(particleBytesSize);
            LuaValue aggregateValue = LuaInstance.getValue(particleType, this.receiveBuffer, 0, particleBytesSize);
            if (!name.equals("SUCCESS")) {
                throw new AerospikeException("Query aggregate expected bin name SUCCESS.  Received " + name);
            }
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            if (aggregateValue == null) continue;
            try {
                this.inputQueue.put(aggregateValue);
            }
            catch (InterruptedException ie) {}
        }
        return true;
    }
}

