/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.QueryCommand;
import com.aerospike.client.query.Statement;

public abstract class QueryExecutor {
    private final QueryPolicy policy;
    protected final Statement statement;
    private QueryThread[] threads;
    private volatile int nextThread;
    private volatile Exception exception;

    public QueryExecutor(QueryPolicy policy, Statement statement) {
        this.policy = policy;
        this.policy.maxRetries = 0;
        this.statement = statement;
    }

    protected final void startThreads(Node[] nodes) {
        this.threads = new QueryThread[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            QueryCommand command = this.createCommand(nodes[i]);
            this.threads[i] = new QueryThread(command);
        }
        int max = this.nextThread = this.policy.maxConcurrentNodes == 0 || this.policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : this.policy.maxConcurrentNodes;
        for (int i = 0; i < max; ++i) {
            this.threads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void threadCompleted() {
        int index2 = -1;
        QueryThread[] queryThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.nextThread < this.threads.length) {
                index2 = this.nextThread++;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (index2 >= 0) {
                this.threads[index2].start();
            } else {
                for (QueryThread thread : this.threads) {
                    if (thread.complete) continue;
                    return;
                }
                this.sendCompleted();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopThreads(Exception cause) {
        Statement statement = this.statement;
        synchronized (statement) {
            if (this.exception != null) {
                return;
            }
            this.exception = cause;
        }
        for (QueryThread thread : this.threads) {
            try {
                thread.stopThread();
                thread.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected final void checkForException() throws AerospikeException {
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    protected abstract QueryCommand createCommand(Node var1);

    protected abstract void sendCompleted();

    private final class QueryThread
    extends Thread {
        private final QueryCommand command;
        private boolean complete;

        public QueryThread(QueryCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.query(QueryExecutor.this.policy, QueryExecutor.this.statement);
            }
            catch (Exception e) {
                QueryExecutor.this.stopThreads(e);
            }
            this.complete = true;
            QueryExecutor.this.threadCompleted();
        }

        public void stopThread() {
            this.command.stop();
        }
    }
}

