/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.QueryCommand;
import com.aerospike.client.query.RecordSet;
import java.io.IOException;
import java.util.HashMap;

public final class QueryRecordCommand
extends QueryCommand {
    private final RecordSet recordSet;

    public QueryRecordCommand(Node node, RecordSet recordSet) {
        super(node);
        this.recordSet = recordSet;
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.receiveOffset = 0;
        while (this.receiveOffset < receiveSize) {
            this.readBytes(22);
            byte resultCode = this.receiveBuffer[5];
            if (resultCode != 0) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.receiveBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int generation = Buffer.bytesToInt(this.receiveBuffer, 6);
            int expiration = Buffer.bytesToInt(this.receiveBuffer, 10);
            int fieldCount = Buffer.bytesToShort(this.receiveBuffer, 18);
            int opCount = Buffer.bytesToShort(this.receiveBuffer, 20);
            Key key = this.parseKey(fieldCount);
            HashMap<String, Object> bins = null;
            for (int i = 0; i < opCount; ++i) {
                this.readBytes(8);
                int opSize = Buffer.bytesToInt(this.receiveBuffer, 0);
                byte particleType = this.receiveBuffer[5];
                byte nameSize = this.receiveBuffer[7];
                this.readBytes(nameSize);
                String name = Buffer.utf8ToString(this.receiveBuffer, 0, nameSize);
                int particleBytesSize = opSize - (4 + nameSize);
                this.readBytes(particleBytesSize);
                Object value = Buffer.bytesToParticle(particleType, this.receiveBuffer, 0, particleBytesSize);
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                bins.put(name, value);
            }
            Record record = new Record(bins, null, generation, expiration);
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            if (this.recordSet.put(new KeyRecord(key, record))) continue;
            this.stop();
            throw new AerospikeException.QueryTerminated();
        }
        return true;
    }
}

