/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.MessagePack;
import org.msgpack.packer.BufferPacker;
import org.msgpack.packer.Packer;
import org.msgpack.unpacker.BufferUnpacker;

public final class MsgPack {
    private static final MessagePack msgpack = new MessagePack();

    public static byte[] pack(Value[] val) throws AerospikeException {
        try {
            BufferPacker packer = msgpack.createBufferPacker();
            MsgPack.packValueArray((Packer)packer, val);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(List<?> val) throws AerospikeException {
        try {
            BufferPacker packer = msgpack.createBufferPacker();
            MsgPack.packList((Packer)packer, val);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(Map<?, ?> val) throws AerospikeException {
        try {
            BufferPacker packer = msgpack.createBufferPacker();
            MsgPack.packMap((Packer)packer, val);
            return packer.toByteArray();
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static void packBytes(Packer packer, byte[] val) throws IOException {
        byte[] buf = new byte[val.length + 1];
        buf[0] = 4;
        System.arraycopy(val, 0, buf, 1, val.length);
        packer.write(buf);
    }

    public static void packString(Packer packer, String val) throws IOException {
        int size = Buffer.estimateSizeUtf8(val);
        byte[] buf = new byte[size + 1];
        buf[0] = 3;
        Buffer.stringToUtf8(val, buf, 1);
        packer.write(buf);
    }

    public static void packValueArray(Packer packer, Value[] values2) throws IOException {
        packer.writeArrayBegin(values2.length);
        for (Value value : values2) {
            value.pack(packer);
        }
        packer.writeArrayEnd();
    }

    public static void packList(Packer packer, List<?> list) throws IOException {
        packer.writeArrayBegin(list.size());
        for (Object obj : list) {
            MsgPack.packObject(packer, obj);
        }
        packer.writeArrayEnd();
    }

    public static void packMap(Packer packer, Map<?, ?> map) throws IOException {
        packer.writeMapBegin(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            MsgPack.packObject(packer, entry.getKey());
            MsgPack.packObject(packer, entry.getValue());
        }
        packer.writeMapEnd();
    }

    public static void packBlob(Packer packer, Object val) throws IOException {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        ObjectOutputStream ostream = new ObjectOutputStream(bstream);
        ostream.writeObject(val);
        ostream.close();
        byte[] buf = bstream.toByteArray();
        buf[0] = 7;
        System.arraycopy(val, 0, buf, 1, buf.length);
        packer.write(buf);
    }

    private static void packObject(Packer packer, Object obj) throws IOException {
        if (obj == null) {
            packer.writeNil();
            return;
        }
        if (obj instanceof String) {
            MsgPack.packString(packer, (String)obj);
            return;
        }
        if (obj instanceof byte[]) {
            MsgPack.packBytes(packer, (byte[])obj);
            return;
        }
        if (obj instanceof Integer) {
            packer.write((Integer)obj);
            return;
        }
        if (obj instanceof Long) {
            packer.write((Long)obj);
            return;
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            value.pack(packer);
            return;
        }
        if (obj instanceof List) {
            MsgPack.packList(packer, (List)obj);
            return;
        }
        if (obj instanceof Map) {
            MsgPack.packMap(packer, (Map)obj);
            return;
        }
        MsgPack.packBlob(packer, obj);
    }

    public static List<?> parseList(byte[] buf, int offset, int len2) throws AerospikeException {
        try {
            BufferUnpacker unpacker = msgpack.createBufferUnpacker(buf, offset, len2);
            return MsgPack.unpackList(unpacker.readValue());
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static Map<?, ?> parseMap(byte[] buf, int offset, int len2) throws AerospikeException {
        try {
            BufferUnpacker unpacker = msgpack.createBufferUnpacker(buf, offset, len2);
            return MsgPack.unpackMap(unpacker.readValue());
        }
        catch (Exception e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    private static Object unpackObject(org.msgpack.type.Value in) throws IOException, ClassNotFoundException {
        switch (in.getType()) {
            case INTEGER: {
                return in.asIntegerValue().getLong();
            }
            case RAW: {
                return MsgPack.unpackBlob(in);
            }
            case MAP: {
                return MsgPack.unpackMap(in);
            }
            case ARRAY: {
                return MsgPack.unpackList(in);
            }
        }
        return null;
    }

    private static List<Object> unpackList(org.msgpack.type.Value in) throws IOException, ClassNotFoundException {
        org.msgpack.type.Value[] elements;
        ArrayList<Object> out = new ArrayList<Object>();
        if (!in.isArrayValue()) {
            return out;
        }
        for (org.msgpack.type.Value v : elements = in.asArrayValue().getElementArray()) {
            out.add(MsgPack.unpackObject(v));
        }
        return out;
    }

    private static Map<Object, Object> unpackMap(org.msgpack.type.Value in) throws IOException, ClassNotFoundException {
        HashMap<Object, Object> out = new HashMap<Object, Object>();
        if (!in.isMapValue()) {
            return out;
        }
        org.msgpack.type.Value[] elements = in.asMapValue().getKeyValueArray();
        for (int i = 0; i < elements.length; ++i) {
            Object key = MsgPack.unpackObject(elements[i]);
            Object val = MsgPack.unpackObject(elements[++i]);
            out.put(key, val);
        }
        return out;
    }

    private static Object unpackBlob(org.msgpack.type.Value in) throws IOException, ClassNotFoundException {
        byte[] raw = in.asRawValue().getByteArray();
        switch (raw[0]) {
            case 3: {
                return Buffer.utf8ToString(raw, 1, raw.length - 1);
            }
            case 7: {
                ByteArrayInputStream bastream = new ByteArrayInputStream(raw, 1, raw.length - 1);
                ObjectInputStream oistream = new ObjectInputStream(bastream);
                return oistream.readObject();
            }
        }
        return Arrays.copyOfRange(raw, 1, raw.length - 1);
    }
}

