/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.LPaint;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.DrawingContent;
import com.airbnb.lottie.animation.content.KeyPathElementContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.animation.content.TrimPathContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.DropShadowKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.IntegerKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseStrokeContent
implements BaseKeyframeAnimation.AnimationListener,
KeyPathElementContent,
DrawingContent {
    private final PathMeasure pm = new PathMeasure();
    private final Path path = new Path();
    private final Path trimPathPath = new Path();
    private final RectF rect = new RectF();
    private final LottieDrawable lottieDrawable;
    protected final BaseLayer layer;
    private final List<PathGroup> pathGroups = new ArrayList<PathGroup>();
    private final float[] dashPatternValues;
    final Paint paint = new LPaint(1);
    private final BaseKeyframeAnimation<?, Float> widthAnimation;
    private final BaseKeyframeAnimation<?, Integer> opacityAnimation;
    private final List<BaseKeyframeAnimation<?, Float>> dashPatternAnimations;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> dashPatternOffsetAnimation;
    @Nullable
    private BaseKeyframeAnimation<ColorFilter, ColorFilter> colorFilterAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> blurAnimation;
    float blurMaskFilterRadius = 0.0f;
    @Nullable
    private DropShadowKeyframeAnimation dropShadowAnimation;

    BaseStrokeContent(LottieDrawable lottieDrawable, BaseLayer layer, Paint.Cap cap, Paint.Join join, float miterLimit, AnimatableIntegerValue opacity, AnimatableFloatValue width, List<AnimatableFloatValue> dashPattern, AnimatableFloatValue offset) {
        int i;
        this.lottieDrawable = lottieDrawable;
        this.layer = layer;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(cap);
        this.paint.setStrokeJoin(join);
        this.paint.setStrokeMiter(miterLimit);
        this.opacityAnimation = opacity.createAnimation();
        this.widthAnimation = width.createAnimation();
        this.dashPatternOffsetAnimation = offset == null ? null : offset.createAnimation();
        this.dashPatternAnimations = new ArrayList(dashPattern.size());
        this.dashPatternValues = new float[dashPattern.size()];
        for (i = 0; i < dashPattern.size(); ++i) {
            this.dashPatternAnimations.add(dashPattern.get(i).createAnimation());
        }
        layer.addAnimation(this.opacityAnimation);
        layer.addAnimation(this.widthAnimation);
        for (i = 0; i < this.dashPatternAnimations.size(); ++i) {
            layer.addAnimation(this.dashPatternAnimations.get(i));
        }
        if (this.dashPatternOffsetAnimation != null) {
            layer.addAnimation(this.dashPatternOffsetAnimation);
        }
        this.opacityAnimation.addUpdateListener(this);
        this.widthAnimation.addUpdateListener(this);
        for (i = 0; i < dashPattern.size(); ++i) {
            this.dashPatternAnimations.get(i).addUpdateListener(this);
        }
        if (this.dashPatternOffsetAnimation != null) {
            this.dashPatternOffsetAnimation.addUpdateListener(this);
        }
        if (layer.getBlurEffect() != null) {
            this.blurAnimation = layer.getBlurEffect().getBlurriness().createAnimation();
            this.blurAnimation.addUpdateListener(this);
            layer.addAnimation(this.blurAnimation);
        }
        if (layer.getDropShadowEffect() != null) {
            this.dropShadowAnimation = new DropShadowKeyframeAnimation(this, layer, layer.getDropShadowEffect());
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        TrimPathContent trimPathContentBefore = null;
        for (int i = contentsBefore.size() - 1; i >= 0; --i) {
            Content content = contentsBefore.get(i);
            if (!(content instanceof TrimPathContent) || ((TrimPathContent)content).getType() != ShapeTrimPath.Type.INDIVIDUALLY) continue;
            trimPathContentBefore = (TrimPathContent)content;
        }
        if (trimPathContentBefore != null) {
            trimPathContentBefore.addListener(this);
        }
        PathGroup currentPathGroup = null;
        for (int i = contentsAfter.size() - 1; i >= 0; --i) {
            Content content = contentsAfter.get(i);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath.Type.INDIVIDUALLY) {
                if (currentPathGroup != null) {
                    this.pathGroups.add(currentPathGroup);
                }
                currentPathGroup = new PathGroup((TrimPathContent)content);
                ((TrimPathContent)content).addListener(this);
                continue;
            }
            if (!(content instanceof PathContent)) continue;
            if (currentPathGroup == null) {
                currentPathGroup = new PathGroup(trimPathContentBefore);
            }
            currentPathGroup.paths.add((PathContent)content);
        }
        if (currentPathGroup != null) {
            this.pathGroups.add(currentPathGroup);
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        L.beginSection("StrokeContent#draw");
        if (Utils.hasZeroScaleAxis(parentMatrix)) {
            L.endSection("StrokeContent#draw");
            return;
        }
        int alpha = (int)((float)parentAlpha / 255.0f * (float)((IntegerKeyframeAnimation)this.opacityAnimation).getIntValue() / 100.0f * 255.0f);
        this.paint.setAlpha(MiscUtils.clamp(alpha, 0, 255));
        this.paint.setStrokeWidth(((FloatKeyframeAnimation)this.widthAnimation).getFloatValue() * Utils.getScale(parentMatrix));
        if (this.paint.getStrokeWidth() <= 0.0f) {
            L.endSection("StrokeContent#draw");
            return;
        }
        this.applyDashPatternIfNeeded(parentMatrix);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter(this.colorFilterAnimation.getValue());
        }
        if (this.blurAnimation != null) {
            float blurRadius = this.blurAnimation.getValue().floatValue();
            if (blurRadius == 0.0f) {
                this.paint.setMaskFilter(null);
            } else if (blurRadius != this.blurMaskFilterRadius) {
                BlurMaskFilter blur = this.layer.getBlurMaskFilter(blurRadius);
                this.paint.setMaskFilter((MaskFilter)blur);
            }
            this.blurMaskFilterRadius = blurRadius;
        }
        if (this.dropShadowAnimation != null) {
            this.dropShadowAnimation.applyTo(this.paint);
        }
        for (int i = 0; i < this.pathGroups.size(); ++i) {
            PathGroup pathGroup = this.pathGroups.get(i);
            if (pathGroup.trimPath != null) {
                this.applyTrimPath(canvas, pathGroup, parentMatrix);
                continue;
            }
            L.beginSection("StrokeContent#buildPath");
            this.path.reset();
            for (int j = pathGroup.paths.size() - 1; j >= 0; --j) {
                this.path.addPath(((PathContent)pathGroup.paths.get(j)).getPath(), parentMatrix);
            }
            L.endSection("StrokeContent#buildPath");
            L.beginSection("StrokeContent#drawPath");
            canvas.drawPath(this.path, this.paint);
            L.endSection("StrokeContent#drawPath");
        }
        L.endSection("StrokeContent#draw");
    }

    private void applyTrimPath(Canvas canvas, PathGroup pathGroup, Matrix parentMatrix) {
        L.beginSection("StrokeContent#applyTrimPath");
        if (pathGroup.trimPath == null) {
            L.endSection("StrokeContent#applyTrimPath");
            return;
        }
        this.path.reset();
        for (int j = pathGroup.paths.size() - 1; j >= 0; --j) {
            this.path.addPath(((PathContent)pathGroup.paths.get(j)).getPath(), parentMatrix);
        }
        this.pm.setPath(this.path, false);
        float totalLength = this.pm.getLength();
        while (this.pm.nextContour()) {
            totalLength += this.pm.getLength();
        }
        float offsetLength = totalLength * pathGroup.trimPath.getOffset().getValue().floatValue() / 360.0f;
        float startLength = totalLength * (pathGroup.trimPath.getStart().getValue().floatValue() / 100.0f) + offsetLength;
        float endLength = totalLength * (pathGroup.trimPath.getEnd().getValue().floatValue() / 100.0f) + offsetLength;
        float currentLength = 0.0f;
        for (int j = pathGroup.paths.size() - 1; j >= 0; --j) {
            float endValue;
            float startValue;
            this.trimPathPath.set(((PathContent)pathGroup.paths.get(j)).getPath());
            this.trimPathPath.transform(parentMatrix);
            this.pm.setPath(this.trimPathPath, false);
            float length = this.pm.getLength();
            if (endLength > totalLength && endLength - totalLength < currentLength + length && currentLength < endLength - totalLength) {
                startValue = startLength > totalLength ? (startLength - totalLength) / length : 0.0f;
                endValue = Math.min((endLength - totalLength) / length, 1.0f);
                Utils.applyTrimPathIfNeeded(this.trimPathPath, startValue, endValue, 0.0f);
                canvas.drawPath(this.trimPathPath, this.paint);
            } else if (!(currentLength + length < startLength) && !(currentLength > endLength)) {
                if (currentLength + length <= endLength && startLength < currentLength) {
                    canvas.drawPath(this.trimPathPath, this.paint);
                } else {
                    startValue = startLength < currentLength ? 0.0f : (startLength - currentLength) / length;
                    endValue = endLength > currentLength + length ? 1.0f : (endLength - currentLength) / length;
                    Utils.applyTrimPathIfNeeded(this.trimPathPath, startValue, endValue, 0.0f);
                    canvas.drawPath(this.trimPathPath, this.paint);
                }
            }
            currentLength += length;
        }
        L.endSection("StrokeContent#applyTrimPath");
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        L.beginSection("StrokeContent#getBounds");
        this.path.reset();
        for (int i = 0; i < this.pathGroups.size(); ++i) {
            PathGroup pathGroup = this.pathGroups.get(i);
            for (int j = 0; j < pathGroup.paths.size(); ++j) {
                this.path.addPath(((PathContent)pathGroup.paths.get(j)).getPath(), parentMatrix);
            }
        }
        this.path.computeBounds(this.rect, false);
        float width = ((FloatKeyframeAnimation)this.widthAnimation).getFloatValue();
        this.rect.set(this.rect.left - width / 2.0f, this.rect.top - width / 2.0f, this.rect.right + width / 2.0f, this.rect.bottom + width / 2.0f);
        outBounds.set(this.rect);
        outBounds.set(outBounds.left - 1.0f, outBounds.top - 1.0f, outBounds.right + 1.0f, outBounds.bottom + 1.0f);
        L.endSection("StrokeContent#getBounds");
    }

    private void applyDashPatternIfNeeded(Matrix parentMatrix) {
        L.beginSection("StrokeContent#applyDashPattern");
        if (this.dashPatternAnimations.isEmpty()) {
            L.endSection("StrokeContent#applyDashPattern");
            return;
        }
        float scale = Utils.getScale(parentMatrix);
        int i = 0;
        while (i < this.dashPatternAnimations.size()) {
            this.dashPatternValues[i] = this.dashPatternAnimations.get(i).getValue().floatValue();
            if (i % 2 == 0) {
                if (this.dashPatternValues[i] < 1.0f) {
                    this.dashPatternValues[i] = 1.0f;
                }
            } else if (this.dashPatternValues[i] < 0.1f) {
                this.dashPatternValues[i] = 0.1f;
            }
            int n = i++;
            this.dashPatternValues[n] = this.dashPatternValues[n] * scale;
        }
        float offset = this.dashPatternOffsetAnimation == null ? 0.0f : this.dashPatternOffsetAnimation.getValue().floatValue() * scale;
        this.paint.setPathEffect((PathEffect)new DashPathEffect(this.dashPatternValues, offset));
        L.endSection("StrokeContent#applyDashPattern");
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        MiscUtils.resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath, this);
    }

    @Override
    @CallSuper
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (property == LottieProperty.OPACITY) {
            this.opacityAnimation.setValueCallback(callback);
        } else if (property == LottieProperty.STROKE_WIDTH) {
            this.widthAnimation.setValueCallback(callback);
        } else if (property == LottieProperty.COLOR_FILTER) {
            if (this.colorFilterAnimation != null) {
                this.layer.removeAnimation(this.colorFilterAnimation);
            }
            if (callback == null) {
                this.colorFilterAnimation = null;
            } else {
                this.colorFilterAnimation = new ValueCallbackKeyframeAnimation<ColorFilter, T>(callback);
                this.colorFilterAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorFilterAnimation);
            }
        } else if (property == LottieProperty.BLUR_RADIUS) {
            if (this.blurAnimation != null) {
                this.blurAnimation.setValueCallback(callback);
            } else {
                this.blurAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.blurAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.blurAnimation);
            }
        } else if (property == LottieProperty.DROP_SHADOW_COLOR && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setColorCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_OPACITY && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setOpacityCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DIRECTION && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDirectionCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DISTANCE && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDistanceCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_RADIUS && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setRadiusCallback(callback);
        }
    }

    private static final class PathGroup {
        private final List<PathContent> paths = new ArrayList<PathContent>();
        @Nullable
        private final TrimPathContent trimPath;

        private PathGroup(@Nullable TrimPathContent trimPath) {
            this.trimPath = trimPath;
        }
    }
}

