/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class SQLSelectParser
extends SQLParser {
    protected SQLExprParser exprParser;

    public SQLSelectParser(String sql) {
        super(sql);
    }

    public SQLSelectParser(Lexer lexer) {
        super(lexer);
    }

    public SQLSelectParser(SQLExprParser exprParser) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
    }

    public SQLSelect select() {
        SQLSelect select = new SQLSelect();
        this.withSubquery(select);
        select.setQuery(this.query());
        select.setOrderBy(this.parseOrderBy());
        if (select.getOrderBy() == null) {
            select.setOrderBy(this.parseOrderBy());
        }
        while (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(select.getHints());
        }
        return select;
    }

    protected SQLUnionQuery createSQLUnionQuery() {
        return new SQLUnionQuery();
    }

    public SQLUnionQuery unionRest(SQLUnionQuery union) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            union.setOrderBy(orderBy);
            return this.unionRest(union);
        }
        return union;
    }

    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) {
        if (this.lexer.token() == Token.UNION) {
            this.lexer.nextToken();
            SQLUnionQuery union = this.createSQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token() == Token.ALL) {
                union.setOperator(SQLUnionOperator.UNION_ALL);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.DISTINCT);
                this.lexer.nextToken();
            }
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return this.unionRest(union);
        }
        if (this.lexer.token() == Token.EXCEPT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.EXCEPT);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        if (this.lexer.token() == Token.INTERSECT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.INTERSECT);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        if (this.lexer.token() == Token.MINUS) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.MINUS);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        return selectQuery;
    }

    public SQLSelectQuery query() {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        this.accept(Token.SELECT);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock();
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        return this.queryRest(queryBlock);
    }

    protected void withSubquery(SQLSelect select) {
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
            if (this.lexer.token == Token.RECURSIVE || this.identifierEquals("RECURSIVE")) {
                this.lexer.nextToken();
                withQueryClause.setRecursive(true);
            }
            while (true) {
                SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
                entry.setParent(withQueryClause);
                entry.setName((SQLIdentifierExpr)this.exprParser.name());
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(entry.getColumns());
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.AS);
                this.accept(Token.LPAREN);
                entry.setSubQuery(this.select());
                this.accept(Token.RPAREN);
                withQueryClause.getEntries().add(entry);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            select.setWithSubQuery(withQueryClause);
        }
    }

    protected void parseWhere(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            queryBlock.setWhere(this.expr());
        }
    }

    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            while (true) {
                groupBy.addItem(this.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                groupBy.setHaving(this.expr());
            }
            queryBlock.setGroupBy(groupBy);
        } else if (this.lexer.token() == Token.HAVING) {
            this.lexer.nextToken();
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            groupBy.setHaving(this.expr());
            queryBlock.setGroupBy(groupBy);
        }
    }

    protected final void parseSelectList(SQLSelectQueryBlock queryBlock) {
        List<SQLSelectItem> selectList = queryBlock.getSelectList();
        while (true) {
            SQLSelectItem selectItem = this.parseSelectItem();
            selectList.add(selectItem);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    protected SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        boolean connectByRoot = false;
        if (this.lexer.token() == Token.IDENTIFIER) {
            if (this.identifierEquals("CONNECT_BY_ROOT")) {
                connectByRoot = true;
                this.lexer.nextToken();
            }
            expr = new SQLIdentifierExpr(this.lexer.stringVal());
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) {
                expr = this.exprParser.primaryRest(expr);
                expr = this.exprParser.exprRest(expr);
            }
        } else {
            expr = this.expr();
        }
        String alias = this.as();
        return new SQLSelectItem(expr, alias, connectByRoot);
    }

    public void parseFrom(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() != Token.FROM) {
            return;
        }
        this.lexer.nextToken();
        queryBlock.setFrom(this.parseTableSource());
    }

    public SQLTableSource parseTableSource() {
        if (this.lexer.token() == Token.LPAREN) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.WITH) {
                SQLSelect select = this.select();
                this.accept(Token.RPAREN);
                SQLSelectQuery query = this.queryRest(select.getQuery());
                tableSource = query instanceof SQLUnionQuery ? new SQLUnionQueryTableSource((SQLUnionQuery)query) : new SQLSubqueryTableSource(select);
            } else if (this.lexer.token() == Token.LPAREN) {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            } else {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            }
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.SELECT) {
            throw new ParserException("TODO");
        }
        SQLExprTableSource tableReference = new SQLExprTableSource();
        this.parseTableSourceQueryTableExpr(tableReference);
        return this.parseTableSourceRest(tableReference);
    }

    private void parseTableSourceQueryTableExpr(SQLExprTableSource tableReference) {
        if (this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.IDENTIFIED || this.lexer.token() == Token.LITERAL_CHARS) {
            tableReference.setExpr(this.exprParser.name());
            return;
        }
        tableReference.setExpr(this.expr());
    }

    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        String alias;
        if (!(tableSource.getAlias() != null && tableSource.getAlias().length() != 0 || this.lexer.token() == Token.LEFT || this.lexer.token() == Token.RIGHT || this.lexer.token() == Token.FULL || this.identifierEquals("STRAIGHT_JOIN") || this.identifierEquals("CROSS") || this.lexer.token == Token.OUTER || (alias = this.as()) == null)) {
            tableSource.setAlias(alias);
            return this.parseTableSourceRest(tableSource);
        }
        SQLJoinTableSource.JoinType joinType = null;
        if (this.lexer.token() == Token.LEFT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
        } else if (this.lexer.token() == Token.RIGHT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN;
        } else if (this.lexer.token() == Token.FULL) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.FULL_OUTER_JOIN;
        } else if (this.lexer.token() == Token.INNER) {
            this.lexer.nextToken();
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.INNER_JOIN;
        } else if (this.lexer.token() == Token.JOIN) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.JOIN;
        } else if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.COMMA;
        } else if (this.identifierEquals("STRAIGHT_JOIN")) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.STRAIGHT_JOIN;
        } else if (this.identifierEquals("CROSS")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.JOIN) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.CROSS_JOIN;
            } else if (this.identifierEquals("APPLY")) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.CROSS_APPLY;
            }
        } else if (this.lexer.token() == Token.OUTER) {
            this.lexer.nextToken();
            if (this.identifierEquals("APPLY")) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.OUTER_APPLY;
            }
        }
        if (joinType != null) {
            SQLJoinTableSource join = new SQLJoinTableSource();
            join.setLeft(tableSource);
            join.setJoinType(joinType);
            join.setRight(this.parseTableSource());
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                join.setCondition(this.expr());
            } else if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else {
                    join.getUsing().add(this.expr());
                }
            }
            return this.parseTableSourceRest(join);
        }
        return tableSource;
    }

    public SQLExpr expr() {
        return this.exprParser.expr();
    }

    public SQLOrderBy parseOrderBy() {
        return this.exprParser.parseOrderBy();
    }

    public void acceptKeyword(String ident) {
        if (this.lexer.token() != Token.IDENTIFIER || !ident.equalsIgnoreCase(this.lexer.stringVal())) {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, expect " + ident + ", actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
    }
}

