/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.style;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.AbstractCellStyleStrategy;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractVerticalCellStyleStrategy
extends AbstractCellStyleStrategy {
    private Workbook workbook;
    private Map<Integer, CellStyle> headCellStyleCache = new HashMap<Integer, CellStyle>();
    private Map<Integer, CellStyle> contentCellStyleCache = new HashMap<Integer, CellStyle>();

    @Override
    protected void initCellStyle(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    protected void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (head == null) {
            return;
        }
        int columnIndex = head.getColumnIndex();
        if (this.headCellStyleCache.containsKey(columnIndex)) {
            CellStyle cellStyle = this.headCellStyleCache.get(columnIndex);
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            return;
        }
        WriteCellStyle headCellStyle = this.headCellStyle(head);
        if (headCellStyle == null) {
            this.headCellStyleCache.put(columnIndex, null);
        } else {
            CellStyle cellStyle = StyleUtil.buildHeadCellStyle(this.workbook, headCellStyle);
            this.headCellStyleCache.put(columnIndex, cellStyle);
            cell.setCellStyle(cellStyle);
        }
    }

    @Override
    protected void setContentCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (head == null) {
            return;
        }
        int columnIndex = head.getColumnIndex();
        if (this.contentCellStyleCache.containsKey(columnIndex)) {
            CellStyle cellStyle = this.contentCellStyleCache.get(columnIndex);
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            return;
        }
        WriteCellStyle contentCellStyle = this.contentCellStyle(head);
        if (contentCellStyle == null) {
            this.contentCellStyleCache.put(columnIndex, null);
        } else {
            CellStyle cellStyle = StyleUtil.buildContentCellStyle(this.workbook, contentCellStyle);
            this.contentCellStyleCache.put(columnIndex, cellStyle);
            cell.setCellStyle(cellStyle);
        }
    }

    protected abstract WriteCellStyle headCellStyle(Head var1);

    protected abstract WriteCellStyle contentCellStyle(Head var1);
}

