/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ha3engine.async.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.ha3engine.async.models.QueryRequest;
import com.aliyun.sdk.ha3engine.async.core.models.Request;
import java.util.List;

public class MultiQueryRequest
extends Request {
    @Body
    @NameInMap(value="tableName")
    @Validation(required=true)
    private String tableName;
    @Body
    @NameInMap(value="queries")
    @Validation(required=true)
    private List<QueryRequest> queries;
    @Body
    @NameInMap(value="topK")
    private Integer topK;
    @Body
    @NameInMap(value="includeVector")
    private Boolean includeVector;
    @Body
    @NameInMap(value="outputFields")
    private List<String> outputFields;
    @Body
    @NameInMap(value="order")
    private String order;
    @Body
    @NameInMap(value="filter")
    private String filter;
    @Body
    @NameInMap(value="sort")
    private String sort;

    private MultiQueryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.tableName = builder.tableName;
        this.queries = builder.queries;
        this.topK = builder.topK;
        this.includeVector = builder.includeVector;
        this.outputFields = builder.outputFields;
        this.order = builder.order;
        this.filter = builder.filter;
        this.sort = builder.sort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MultiQueryRequest create() {
        return MultiQueryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<QueryRequest> getQueries() {
        return this.queries;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Boolean getIncludeVector() {
        return this.includeVector;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public String getOrder() {
        return this.order;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getSort() {
        return this.sort;
    }

    public static final class Builder
    extends Request.Builder<MultiQueryRequest, Builder> {
        private String tableName;
        private List<QueryRequest> queries;
        private Integer topK;
        private Boolean includeVector;
        private List<String> outputFields;
        private String order;
        private String filter;
        private String sort;

        private Builder() {
        }

        private Builder(MultiQueryRequest request) {
            super((Request)request);
            this.tableName = request.tableName;
            this.queries = request.queries;
            this.topK = request.topK;
            this.includeVector = request.includeVector;
            this.outputFields = request.outputFields;
            this.order = request.order;
            this.filter = request.filter;
            this.sort = request.sort;
        }

        public Builder tableName(String tableName) {
            this.putBodyParameter("tableName", tableName);
            this.tableName = tableName;
            return this;
        }

        public Builder queries(List<QueryRequest> queries) {
            this.putBodyParameter("queries", queries);
            this.queries = queries;
            return this;
        }

        public Builder topK(Integer topK) {
            this.putBodyParameter("topK", topK);
            this.topK = topK;
            return this;
        }

        public Builder includeVector(Boolean includeVector) {
            this.putBodyParameter("includeVector", includeVector);
            this.includeVector = includeVector;
            return this;
        }

        public Builder outputFields(List<String> outputFields) {
            this.putBodyParameter("outputFields", outputFields);
            this.outputFields = outputFields;
            return this;
        }

        public Builder order(String order) {
            this.putBodyParameter("order", order);
            this.order = order;
            return this;
        }

        public Builder filter(String filter) {
            this.putBodyParameter("filter", filter);
            this.filter = filter;
            return this;
        }

        public Builder sort(String sort) {
            this.putBodyParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public MultiQueryRequest build() {
            return new MultiQueryRequest(this);
        }
    }
}

