/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry.backoff;

import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.RetryUtil;
import darabonba.core.policy.retry.backoff.EqualJitterBackoffStrategy;
import darabonba.core.policy.retry.backoff.FixedDelayBackoffStrategy;
import darabonba.core.policy.retry.backoff.FullJitterBackoffStrategy;
import java.time.Duration;

public interface BackoffStrategy {
    public static final int RETRIES_ATTEMPTED_CEILING = (int)Math.floor(Math.log(2.147483647E9) / Math.log(2.0));

    public Duration computeDelayBeforeNextRetry(RetryPolicyContext var1);

    default public int calculateExponentialDelay(int retriesAttempted, Duration baseDelay, Duration maxBackoffTime) {
        int cappedRetries = Math.min(retriesAttempted, RETRIES_ATTEMPTED_CEILING);
        return (int)Math.min(baseDelay.multipliedBy(1L << cappedRetries).toMillis(), maxBackoffTime.toMillis());
    }

    public static BackoffStrategy defaultStrategy() {
        return FullJitterBackoffStrategy.builder().baseDelay(RetryUtil.BASE_DELAY).maxBackoffTime(RetryUtil.MAX_BACKOFF).build();
    }

    public static BackoffStrategy defaultThrottlingStrategy() {
        return EqualJitterBackoffStrategy.builder().baseDelay(RetryUtil.THROTTLED_BASE_DELAY).maxBackoffTime(RetryUtil.MAX_BACKOFF).build();
    }

    public static BackoffStrategy none() {
        return FixedDelayBackoffStrategy.create(Duration.ofMillis(1L));
    }
}

