/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.retry;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public abstract class JedisRetryCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisRetryCommand.class);
    private final JedisPool jedisPool;
    private final int maxRetries;
    private final Duration maxTotalRetriesDuration;

    public JedisRetryCommand(JedisPool jedisPool, int maxRetries, Duration maxTotalRetriesDuration) {
        this.jedisPool = jedisPool;
        this.maxRetries = maxRetries;
        this.maxTotalRetriesDuration = maxTotalRetriesDuration;
    }

    public abstract T execute(Jedis var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T runWithRetries() {
        Instant deadline = Instant.now().plus(this.maxTotalRetriesDuration);
        Exception lastException = null;
        for (int retriesLeft = this.maxRetries; retriesLeft > 0; --retriesLeft) {
            Jedis connection = null;
            try {
                connection = this.jedisPool.getResource();
                T t = this.execute(connection);
                return t;
            }
            catch (Exception jce) {
                lastException = jce;
                LOGGER.warn("Redis throw an exception: {}", (Object)connection, (Object)jce);
                this.sleep(JedisRetryCommand.getBackoffSleepMillis(retriesLeft, deadline));
            }
            finally {
                this.releaseConnection(connection);
            }
            if (!Instant.now().isAfter(deadline)) continue;
            throw new JedisException("Command retry deadline exceeded.");
        }
        JedisException maxRetriesException = new JedisException("No more command retries left.");
        maxRetriesException.addSuppressed((Throwable)lastException);
        throw maxRetriesException;
    }

    private static long getBackoffSleepMillis(int retriesLeft, Instant deadline) {
        if (retriesLeft <= 0) {
            return 0L;
        }
        long millisLeft = Duration.between(Instant.now(), deadline).toMillis();
        if (millisLeft < 0L) {
            throw new JedisException("Command retry deadline exceeded.");
        }
        return millisLeft / ((long)retriesLeft * (long)(retriesLeft + 1));
    }

    private void sleep(long sleepMillis) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            throw new JedisException((Throwable)e);
        }
    }

    private void releaseConnection(Jedis connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

