/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairbloom;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairbloom.factory.BloomBuilderFactory;
import com.aliyun.tair.tairbloom.params.BfinsertParams;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairBloomPipeline
extends Pipeline {
    public TairBloomPipeline(Jedis jedis) {
        super(jedis);
    }

    public Response<String> bfreserve(String key, long initCapacity, double errorRate) {
        return this.bfreserve(SafeEncoder.encode((String)key), initCapacity, errorRate);
    }

    public Response<String> bfreserve(byte[] key, long initCapacity, double errorRate) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFRESERVE).key((Object)key).add(errorRate).add(initCapacity), BuilderFactory.STRING));
    }

    public Response<Boolean> bfadd(String key, String item) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFADD).key((Object)key).add(item), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> bfadd(byte[] key, byte[] item) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFADD).key((Object)key).add(item), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean[]> bfmadd(String key, String ... items) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFMADD).key((Object)key).addObjects((Object[])items), BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST));
    }

    public Response<Boolean[]> bfmadd(byte[] key, byte[] ... items) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFMADD).key((Object)key).addObjects((Object[])items), BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST));
    }

    public Response<Boolean> bfexists(String key, String value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFEXISTS).key((Object)key).add(value), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> bfexists(byte[] key, byte[] value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFEXISTS).key((Object)key).add(value), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean[]> bfmexists(String key, String ... value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFMEXISTS).key((Object)key).addObjects((Object[])value), BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST));
    }

    public Response<Boolean[]> bfmexists(byte[] key, byte[] ... value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFMEXISTS).key((Object)key).addObjects((Object[])value), BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST));
    }

    public Response<Boolean[]> bfinsert(String key, BfinsertParams params, String ... items) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFINSERT).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])items))), BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST));
    }

    public Response<Boolean[]> bfinsert(byte[] key, BfinsertParams params, byte[] ... items) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFINSERT).addObjects((Object[])params.getByteParams(key, items)), BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST));
    }

    public Response<List<String>> bfdebug(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFDEBUG).key((Object)key), BuilderFactory.STRING_LIST));
    }

    public Response<List<String>> bfdebug(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.BFDEBUG).key((Object)key), BuilderFactory.STRING_LIST));
    }
}

