/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairhash;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanParams;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairhash.factory.HashBuilderFactory;
import com.aliyun.tair.tairhash.params.ExhgetwithverResult;
import com.aliyun.tair.tairhash.params.ExhincrByFloatParams;
import com.aliyun.tair.tairhash.params.ExhincrByParams;
import com.aliyun.tair.tairhash.params.ExhmsetwithoptsParams;
import com.aliyun.tair.tairhash.params.ExhsetParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairHashPipeline
extends Pipeline {
    public TairHashPipeline(Jedis jedis) {
        super(jedis);
    }

    public Response<Long> exhset(byte[] key, byte[] field, byte[] value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSET).key((Object)key).add(field).add(value), BuilderFactory.LONG));
    }

    public Response<Long> exhset(String key, String field, String value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSET).key((Object)key).add(field).add(value), BuilderFactory.LONG));
    }

    public Response<Long> exhset(byte[] key, byte[] field, byte[] value, ExhsetParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSET).addObjects((Object[])params.getByteParams(key, field, value)), BuilderFactory.LONG));
    }

    public Response<Long> exhset(String key, String field, String value, ExhsetParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), SafeEncoder.encode((String)value))), BuilderFactory.LONG));
    }

    public Response<Long> exhsetnx(byte[] key, byte[] field, byte[] value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSETNX).key((Object)key).add(field).add(value), BuilderFactory.LONG));
    }

    public Response<Long> exhsetnx(String key, String field, String value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSETNX).key((Object)key).add(field).add(value), BuilderFactory.LONG));
    }

    public Response<String> exhmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(SafeEncoder.encode((String)entry.getKey()), SafeEncoder.encode((String)entry.getValue()));
        }
        return this.exhmset(SafeEncoder.encode((String)key), bhash);
    }

    public Response<String> exhmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHMSET).addObjects(params), BuilderFactory.STRING));
    }

    public Response<String> exhmsetwithopts(String key, List<ExhmsetwithoptsParams<String>> params) {
        ArrayList<ExhmsetwithoptsParams<byte[]>> bexhash = new ArrayList<ExhmsetwithoptsParams<byte[]>>();
        for (ExhmsetwithoptsParams<String> entry : params) {
            bexhash.add(new ExhmsetwithoptsParams<byte[]>(SafeEncoder.encode((String)entry.getField()), SafeEncoder.encode((String)entry.getValue()), entry.getVer(), entry.getExp()));
        }
        return this.exhmsetwithopts(SafeEncoder.encode((String)key), bexhash);
    }

    public Response<String> exhmsetwithopts(byte[] key, List<ExhmsetwithoptsParams<byte[]>> params) {
        ArrayList<byte[]> p = new ArrayList<byte[]>();
        p.add(key);
        for (ExhmsetwithoptsParams<byte[]> entry : params) {
            p.add(entry.getField());
            p.add(entry.getValue());
            p.add(Protocol.toByteArray((long)entry.getVer()));
            p.add(Protocol.toByteArray((long)entry.getExp()));
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHMSETWITHOPTS).addObjects(p), BuilderFactory.STRING));
    }

    public Response<Boolean> exhpexpire(String key, String field, int milliseconds) {
        return this.exhpexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), milliseconds, false);
    }

    public Response<Boolean> exhpexpire(String key, String field, int milliseconds, boolean noactive) {
        return this.exhpexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), milliseconds, noactive);
    }

    public Response<Boolean> exhpexpire(byte[] key, byte[] field, int milliseconds) {
        return this.exhpexpire(key, field, milliseconds, false);
    }

    public Response<Boolean> exhpexpire(byte[] key, byte[] field, int milliseconds, boolean noactive) {
        CommandArguments args = new CommandArguments((ProtocolCommand)ModuleCommand.EXHPEXPIRE);
        args.add(key).add(field).add(milliseconds);
        if (noactive) {
            args.add("noactive");
        }
        return this.appendCommand(new CommandObject(args, BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> exhpexpireAt(String key, String field, long unixTime) {
        return this.exhpexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, false);
    }

    public Response<Boolean> exhpexpireAt(String key, String field, long unixTime, boolean noactive) {
        return this.exhpexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, noactive);
    }

    public Response<Boolean> exhpexpireAt(byte[] key, byte[] field, long unixTime) {
        return this.exhpexpireAt(key, field, unixTime, false);
    }

    public Response<Boolean> exhpexpireAt(byte[] key, byte[] field, long unixTime, boolean noactive) {
        CommandArguments args = new CommandArguments((ProtocolCommand)ModuleCommand.EXHPEXPIREAT);
        args.add(key).add(field).add(unixTime);
        if (noactive) {
            args.add("noactive");
        }
        return this.appendCommand(new CommandObject(args, BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> exhexpire(String key, String field, int seconds) {
        return this.exhexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), seconds, false);
    }

    public Response<Boolean> exhexpire(String key, String field, int seconds, boolean noactive) {
        return this.exhexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), seconds, noactive);
    }

    public Response<Boolean> exhexpire(byte[] key, byte[] field, int seconds) {
        return this.exhexpire(key, field, seconds, false);
    }

    public Response<Boolean> exhexpire(byte[] key, byte[] field, int seconds, boolean noactive) {
        CommandArguments args = new CommandArguments((ProtocolCommand)ModuleCommand.EXHEXPIRE);
        args.add(key).add(field).add(seconds);
        if (noactive) {
            args.add("noactive");
        }
        return this.appendCommand(new CommandObject(args, BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> exhexpireAt(String key, String field, long unixTime) {
        return this.exhexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, false);
    }

    public Response<Boolean> exhexpireAt(String key, String field, long unixTime, boolean noactive) {
        return this.exhexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, noactive);
    }

    public Response<Boolean> exhexpireAt(byte[] key, byte[] field, long unixTime) {
        return this.exhexpireAt(key, field, unixTime, false);
    }

    public Response<Boolean> exhexpireAt(byte[] key, byte[] field, long unixTime, boolean noactive) {
        CommandArguments args = new CommandArguments((ProtocolCommand)ModuleCommand.EXHEXPIREAT);
        args.add(key).add(field).add(unixTime);
        if (noactive) {
            args.add("noactive");
        }
        return this.appendCommand(new CommandObject(args, BuilderFactory.BOOLEAN));
    }

    public Response<Long> exhpttl(String key, String field) {
        return this.exhpttl(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Response<Long> exhpttl(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHPTTL).add(key).add(field), BuilderFactory.LONG));
    }

    public Response<Long> exhttl(String key, String field) {
        return this.exhttl(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Response<Long> exhttl(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHTTL).add(key).add(field), BuilderFactory.LONG));
    }

    public Response<Long> exhver(String key, String field) {
        return this.exhver(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Response<Long> exhver(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHVER).add(key).add(field), BuilderFactory.LONG));
    }

    public Response<Boolean> exhsetver(String key, String field, long version) {
        return this.exhsetver(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), version);
    }

    public Response<Boolean> exhsetver(byte[] key, byte[] field, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSETVER).add(key).add(field).add(version), BuilderFactory.BOOLEAN));
    }

    public Response<Long> exhincrBy(String key, String field, long value) {
        return this.exhincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    public Response<Long> exhincrBy(byte[] key, byte[] field, long value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHINCRBY).add(key).add(field).add(value), BuilderFactory.LONG));
    }

    public Response<Long> exhincrBy(String key, String field, long value, ExhincrByParams params) {
        return this.exhincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value, params);
    }

    public Response<Long> exhincrBy(byte[] key, byte[] field, long value, ExhincrByParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHINCRBY).addObjects((Object[])params.getByteParams(key, field, Protocol.toByteArray((long)value))), BuilderFactory.LONG));
    }

    public Response<Double> exhincrByFloat(String key, String field, double value) {
        return this.exhincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    public Response<Double> exhincrByFloat(byte[] key, byte[] field, double value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHINCRBYFLOAT).add(key).add(field).add(value), BuilderFactory.DOUBLE));
    }

    public Response<Double> exhincrByFloat(String key, String field, double value, ExhincrByFloatParams params) {
        return this.exhincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value, params);
    }

    public Response<Double> exhincrByFloat(byte[] key, byte[] field, double value, ExhincrByFloatParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHINCRBYFLOAT).addObjects((Object[])params.getByteParams(key, field, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<String> exhget(String key, String field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHGET).add(key).add(field), BuilderFactory.STRING));
    }

    public Response<byte[]> exhget(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHGET).add(key).add(field), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<ExhgetwithverResult<String>> exhgetwithver(String key, String field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHGETWITHVER).add(key).add(field), HashBuilderFactory.EXHGETWITHVER_RESULT_STRING));
    }

    public Response<ExhgetwithverResult<byte[]>> exhgetwithver(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHGETWITHVER).add(key).add(field), HashBuilderFactory.EXHGETWITHVER_RESULT_BYTE));
    }

    public Response<List<String>> exhmget(String key, String ... fields) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHMGET).add(key).addObjects((Object[])fields), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exhmget(byte[] key, byte[] ... fields) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHMGET).add(key).addObjects((Object[])fields), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<ExhgetwithverResult<String>>> exhmgetwithver(String key, String ... fields) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHMGETWITHVER).add(key).addObjects((Object[])fields), HashBuilderFactory.EXHMGETWITHVER_RESULT_STRING_LIST));
    }

    public Response<List<ExhgetwithverResult<byte[]>>> exhmgetwithver(byte[] key, byte[] ... fields) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHMGETWITHVER).add(key).addObjects((Object[])fields), HashBuilderFactory.EXHMGETWITHVER_RESULT_BYTE_LIST));
    }

    public Response<Long> exhdel(String key, String ... fields) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHDEL).add(key).addObjects((Object[])fields), BuilderFactory.LONG));
    }

    public Response<Long> exhdel(byte[] key, byte[] ... fields) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHDEL).add(key).addObjects((Object[])fields), BuilderFactory.LONG));
    }

    public Response<Long> exhlen(String key) {
        return this.exhlen(SafeEncoder.encode((String)key), false);
    }

    public Response<Long> exhlen(String key, boolean noexp) {
        return this.exhlen(SafeEncoder.encode((String)key), noexp);
    }

    public Response<Long> exhlen(byte[] key) {
        return this.exhlen(key, false);
    }

    public Response<Long> exhlen(byte[] key, boolean noexp) {
        CommandArguments args = new CommandArguments((ProtocolCommand)ModuleCommand.EXHLEN);
        args.add(key);
        if (noexp) {
            args.add("noexp");
        }
        return this.appendCommand(new CommandObject(args, BuilderFactory.LONG));
    }

    public Response<Boolean> exhexists(String key, String field) {
        return this.exhexists(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Response<Boolean> exhexists(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHEXISTS).add(key).add(field), BuilderFactory.BOOLEAN));
    }

    public Response<Long> exhstrlen(String key, String field) {
        return this.exhstrlen(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    public Response<Long> exhstrlen(byte[] key, byte[] field) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSTRLEN).add(key).add(field), BuilderFactory.LONG));
    }

    public Response<Set<String>> exhkeys(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHKEYS).add(key), Jedis3BuilderFactory.STRING_ZSET));
    }

    public Response<Set<byte[]>> exhkeys(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHKEYS).add(key), Jedis3BuilderFactory.BYTE_ARRAY_ZSET));
    }

    public Response<List<String>> exhvals(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHVALS).add(key), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exhvals(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHVALS).add(key), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<Map<String, String>> exhgetAll(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHGETALL).add(key), BuilderFactory.STRING_MAP));
    }

    public Response<Map<byte[], byte[]>> exhgetAll(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHGETALL).add(key), Jedis3BuilderFactory.BYTE_ARRAY_MAP));
    }

    public Response<ScanResult<Map.Entry<String, String>>> exhscan(String key, String op, String subkey) {
        return this.exhscan(key, op, subkey, new ScanParams());
    }

    public Response<ScanResult<Map.Entry<String, String>>> exhscan(String key, String op, String subkey, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)op));
        args.add(SafeEncoder.encode((String)subkey));
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSCAN).addObjects(args), HashBuilderFactory.EXHSCAN_RESULT_STRING));
    }

    public Response<ScanResult<Map.Entry<byte[], byte[]>>> exhscan(byte[] key, byte[] op, byte[] subkey) {
        return this.exhscan(key, op, subkey, new ScanParams());
    }

    public Response<ScanResult<Map.Entry<byte[], byte[]>>> exhscan(byte[] key, byte[] op, byte[] subkey, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(op);
        args.add(subkey);
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSCAN).addObjects(args), HashBuilderFactory.EXHSCAN_RESULT_BYTE));
    }

    public Response<ScanResult<Map.Entry<String, String>>> exhscanunorder(String key, String cursor) {
        return this.exhscanunorder(key, cursor, new ScanParams());
    }

    public Response<ScanResult<Map.Entry<byte[], byte[]>>> exhscanunorder(byte[] key, byte[] cursor) {
        return this.exhscanunorder(key, cursor, new ScanParams());
    }

    public Response<ScanResult<Map.Entry<String, String>>> exhscanunorder(String key, String cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)cursor));
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSCANUNORDER).addObjects(args), HashBuilderFactory.EXHSCAN_RESULT_STRING));
    }

    public Response<ScanResult<Map.Entry<byte[], byte[]>>> exhscanunorder(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXHSCANUNORDER).addObjects(args), HashBuilderFactory.EXHSCAN_RESULT_BYTE));
    }
}

