/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.embedded;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class DDBExceptionMappingInvocationHandler
implements InvocationHandler {
    private final LocalDBClient impl;
    private final ReentrantReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private boolean isShutdown = false;

    DDBExceptionMappingInvocationHandler(LocalDBClient impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("shutdown")) {
            this.shutdownLock.writeLock().lock();
            try {
                if (!this.isShutdown) {
                    this.impl.shutdown();
                    this.isShutdown = true;
                }
                Object var4_4 = null;
                return var4_4;
            }
            finally {
                this.shutdownLock.writeLock().unlock();
            }
        }
        this.shutdownLock.readLock().lock();
        try {
            if (!this.isShutdown) {
                Object result = null;
                try {
                    Object object = result = method.invoke((Object)this.impl, args);
                    return object;
                }
                catch (InvocationTargetException ie) {
                    Throwable e = ie.getTargetException();
                    if (e.getClass().isAssignableFrom(DynamoDBLocalServiceException.class)) {
                        DDBExceptionMappingInvocationHandler.handleDynamoDBLocalServiceException((DynamoDBLocalServiceException)((Object)e));
                    }
                    throw e;
                }
            }
            throw new AmazonServiceException("Embedded server is shut down");
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    public static void handleDynamoDBLocalServiceException(DynamoDBLocalServiceException le) throws Throwable {
        AmazonServiceException ase;
        AmazonServiceExceptionType exceptionType = AmazonServiceExceptionType.valueOfErrorCode(le.getErrorCode());
        Class<? extends AmazonServiceException> clientException = exceptionType.getClientClass();
        if (AmazonServiceException.class.equals(clientException)) {
            ase = new AmazonServiceException(le.getMessage());
        } else {
            Constructor<? extends AmazonServiceException> constructor = clientException.getConstructor(String.class);
            ase = constructor.newInstance(le.getMessage());
        }
        DDBExceptionMappingInvocationHandler.copyAmazonServiceExceptionFields(ase, le);
        throw ase;
    }

    private static void copyAmazonServiceExceptionFields(AmazonServiceException dst, AmazonServiceException src) {
        if (src == null || dst == null) {
            return;
        }
        dst.setErrorCode(src.getErrorCode());
        dst.setStatusCode(src.getStatusCode());
        dst.setRequestId(src.getRequestId());
        dst.setServiceName(src.getServiceName());
        dst.setErrorType(src.getErrorType());
    }
}

