/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.embedded;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.local.embedded.DDBExceptionMappingInvocationHandler;
import com.amazonaws.services.dynamodbv2.local.shared.access.AmazonDynamoDBLocal;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.JobsRegister;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamoDBEmbedded {
    public static final String SQLITE4JAVA_PKG = "com.almworks.sqlite4java";

    public static AmazonDynamoDBLocal create() {
        return DynamoDBEmbedded.create(null);
    }

    public static AmazonDynamoDBLocal create(File file) {
        JobsRegister jobs = new JobsRegister(Executors.newFixedThreadPool(10), false);
        SQLiteDBAccess dbAccess = file == null ? new SQLiteDBAccess() : new SQLiteDBAccess(file);
        LocalDBClient impl = new LocalDBClient(dbAccess, jobs);
        final DDBExceptionMappingInvocationHandler handler = new DDBExceptionMappingInvocationHandler(impl);
        return new AmazonDynamoDBLocal(){
            AmazonDynamoDBLocal proxy;
            AmazonDynamoDB ddbProxy;
            AmazonDynamoDBStreams ddbStreamsProxy;
            {
                this.proxy = (AmazonDynamoDBLocal)Proxy.newProxyInstance(AmazonDynamoDBLocal.class.getClassLoader(), new Class[]{AmazonDynamoDBLocal.class}, (InvocationHandler)handler);
                this.ddbProxy = (AmazonDynamoDB)Proxy.newProxyInstance(AmazonDynamoDB.class.getClassLoader(), new Class[]{AmazonDynamoDB.class}, (InvocationHandler)handler);
                this.ddbStreamsProxy = (AmazonDynamoDBStreams)Proxy.newProxyInstance(AmazonDynamoDBStreams.class.getClassLoader(), new Class[]{AmazonDynamoDBStreams.class}, (InvocationHandler)handler);
            }

            @Override
            public void triggerShardRollovers() {
                this.proxy.triggerShardRollovers();
            }

            @Override
            public void shutdown() {
                this.proxy.shutdown();
            }

            @Override
            public void dilateEventTimes(long ms) {
                this.proxy.dilateEventTimes(ms);
            }

            @Override
            public AmazonDynamoDBStreams amazonDynamoDBStreams() {
                return this.ddbStreamsProxy;
            }

            @Override
            public AmazonDynamoDB amazonDynamoDB() {
                return this.ddbProxy;
            }
        };
    }

    static {
        Logger.getLogger(SQLITE4JAVA_PKG).setLevel(Level.OFF);
    }
}

