/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodel;

import com.amazonaws.services.dynamodbv2.datamodel.DocPathElement;
import com.amazonaws.services.dynamodbv2.datamodel.DocPathListElement;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentNode;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentNodeType;
import com.amazonaws.services.dynamodbv2.datamodel.Operator;
import com.amazonaws.services.dynamodbv2.datamodel.TypeSet;
import com.amazonaws.services.dynamodbv2.datamodel.impl.DocumentNodeRawByteComparator;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.dbenv.DbExecutionError;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class OperatorExecutor {
    protected final DbEnv dbEnv;
    protected final DocumentFactory docFactory;
    protected final DocumentNodeRawByteComparator rawBytesComparator;

    public OperatorExecutor(DbEnv dbEnv, DocumentFactory factory) {
        this.dbEnv = dbEnv;
        this.docFactory = factory;
        this.rawBytesComparator = new DocumentNodeRawByteComparator(this.docFactory);
    }

    public DbEnv getDbEnv() {
        return this.dbEnv;
    }

    public DocumentFactory getDocFactory() {
        return this.docFactory;
    }

    public DocumentNode addition(DocumentNode leftOp, DocumentNode rightOp) {
        return this.numberMath(leftOp, rightOp, Operator.ADDITION);
    }

    private DocumentNode numberMath(DocumentNode leftOp, DocumentNode rightOp, Operator mathOp) {
        this.dbEnv.dbAssert(mathOp == Operator.ADDITION || mathOp == Operator.SUBTRACTION, "OperatorExecutor", "bad math op", new Object[0]);
        BigDecimal left = leftOp.getNValue();
        BigDecimal right = rightOp.getNValue();
        BigDecimal result = mathOp == Operator.ADDITION ? left.add(right) : left.subtract(right);
        DocumentNode resultNode = this.docFactory.makeNumber(result);
        this.dbEnv.dbAssert(resultNode != null, "OperatorExecutor.numberMath", "number doc is null", new Object[0]);
        return resultNode;
    }

    public DocumentNode subtraction(DocumentNode leftOp, DocumentNode rightOp) {
        return this.numberMath(leftOp, rightOp, Operator.SUBTRACTION);
    }

    public DocumentNode setUnion(DocumentNode first, DocumentNode second) {
        List<byte[]> oldArray = first.getRawSetValue();
        List<byte[]> newArray = second.getRawSetValue();
        ArrayList<byte[]> resultArray = new ArrayList<byte[]>(oldArray.size() + newArray.size());
        int oldIdx = 0;
        int newIdx = 0;
        boolean anythingNewAdded = false;
        while (true) {
            boolean addNew = false;
            if (oldIdx < oldArray.size()) {
                byte[] baOld = oldArray.get(oldIdx);
                DocumentNode docOld = this.docFactory.makeBinary(baOld);
                boolean addOld = false;
                if (newIdx < newArray.size()) {
                    byte[] baNew = newArray.get(newIdx);
                    DocumentNode docNew = this.docFactory.makeBinary(baNew);
                    int cmp = docOld.compare(docNew);
                    if (cmp == 0) {
                        addOld = true;
                        ++newIdx;
                    } else if (cmp < 0) {
                        addOld = true;
                    } else {
                        addNew = true;
                    }
                } else {
                    if (!anythingNewAdded) break;
                    addOld = true;
                }
                if (addOld) {
                    resultArray.add(baOld);
                    ++oldIdx;
                }
            } else {
                if (newIdx >= newArray.size()) break;
                addNew = true;
            }
            if (!addNew) continue;
            byte[] baNew = newArray.get(newIdx);
            resultArray.add(baNew);
            anythingNewAdded = true;
            ++newIdx;
        }
        if (!anythingNewAdded) {
            return first;
        }
        return this.docFactory.makeSet(first.getNodeType(), resultArray);
    }

    public DocumentNode setDiff(DocumentNode oldValue, DocumentNode newValue, boolean returnEmptySet) {
        this.dbEnv.dbAssert(!returnEmptySet, "OperatorExecutor.setDiff", "set_diff not supported yet", new Object[0]);
        List<byte[]> oldArray = oldValue.getRawSetValue();
        List<byte[]> valuesToBeRemoved = newValue.getRawSetValue();
        HashSet<Integer> toBeRemovedIdx = new HashSet<Integer>(valuesToBeRemoved.size());
        for (byte[] ba : valuesToBeRemoved) {
            int idx = Collections.binarySearch(oldArray, ba, this.rawBytesComparator);
            if (idx < 0) continue;
            boolean added = toBeRemovedIdx.add(idx);
            this.dbEnv.dbAssert(added, "OperatorExecutor.setDiff", "duplicate in set", "oldArray", oldArray, "value", ba, "idx", idx);
        }
        if (toBeRemovedIdx.isEmpty()) {
            return oldValue;
        }
        int remaining = oldArray.size() - toBeRemovedIdx.size();
        this.dbEnv.dbAssert(remaining >= 0, "OperatorExecutor.setDiff", "impossible case of removing more values than in the original set", new Object[0]);
        if (remaining == 0) {
            return null;
        }
        ArrayList<byte[]> newArray = new ArrayList<byte[]>(remaining);
        for (int i = 0; i < oldArray.size(); ++i) {
            byte[] ba = oldArray.get(i);
            if (toBeRemovedIdx.contains(i)) continue;
            newArray.add(ba);
        }
        return this.docFactory.makeSet(oldValue.getNodeType(), newArray);
    }

    public boolean contains(DocumentNode first, DocumentNode second) {
        if (first == null || second == null) {
            return false;
        }
        if (TypeSet.STRING_BINARY.contains(first.getNodeType())) {
            if (first.getNodeType() != second.getNodeType()) {
                return false;
            }
            return OperatorExecutor.indexOf(first.getRawScalarValue(), second.getRawScalarValue(), false) != -1;
        }
        if (first.getNodeType() == DocumentNodeType.LIST) {
            return this.listContains(first, second);
        }
        if (first.getNodeType() == DocumentNodeType.NUMBER_SET && second.getNodeType() == DocumentNodeType.NUMBER || first.getNodeType() == DocumentNodeType.STRING_SET && second.getNodeType() == DocumentNodeType.STRING || first.getNodeType() == DocumentNodeType.BINARY_SET && second.getNodeType() == DocumentNodeType.BINARY) {
            return this.setContains(first, second);
        }
        return false;
    }

    private boolean setContains(DocumentNode first, DocumentNode second) {
        int index = Collections.binarySearch(first.getRawSetValue(), second.getRawScalarValue(), this.rawBytesComparator);
        if (index >= 0) {
            this.dbEnv.dbAssert(index < first.getRawSetValue().size(), "OperatorExecutor.setContains", "A positive index implies that the value is contained in the list, however the index exceeds array bounds.", new Object[0]);
            return true;
        }
        return false;
    }

    private boolean listContains(DocumentNode first, DocumentNode second) {
        for (DocPathElement e : first.getChildren()) {
            if (!first.getChild(e).eq(second)) continue;
            return true;
        }
        return false;
    }

    protected static int indexOf(byte[] source, byte[] target, boolean beginsWith) {
        if (target.length > source.length) {
            return -1;
        }
        int scanLength = 0;
        scanLength = beginsWith ? 1 : source.length - target.length + 1;
        for (int i = 0; i < scanLength; ++i) {
            boolean matched = true;
            for (int j = 0; j < target.length; ++j) {
                if (source[i + j] == target[j]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return i;
        }
        return -1;
    }

    public boolean beginsWith(DocumentNode first, DocumentNode second) {
        if (!OperatorExecutor.typeMatch(first, second)) {
            return false;
        }
        return OperatorExecutor.indexOf(first.getRawScalarValue(), second.getRawScalarValue(), true) == 0;
    }

    public DocumentNode listAppend(DocumentNode first, DocumentNode second) {
        DocumentNode prev;
        int i;
        List<DocPathElement> list_1 = first.getChildren();
        List<DocPathElement> list_2 = second.getChildren();
        TreeMap<DocPathElement, DocumentNode> nodeMap = new TreeMap<DocPathElement, DocumentNode>();
        for (i = 0; i < list_1.size(); ++i) {
            prev = nodeMap.put(new DocPathListElement(i), first.getChild(list_1.get(i)));
            this.dbEnv.dbAssert(prev == null, "OperatorExecutor.listAppend", "bad list index 1", new Object[0]);
        }
        for (i = 0; i < list_2.size(); ++i) {
            prev = nodeMap.put(new DocPathListElement(i + list_1.size()), second.getChild(list_2.get(i)));
            this.dbEnv.dbAssert(prev == null, "OperatorExecutor.listAppend", "bad list index 1", new Object[0]);
        }
        return this.docFactory.makeMapOrListNode(nodeMap, false);
    }

    public DocumentNode ifNotExist(DocumentNode first, DocumentNode second) {
        if (second == null) {
            this.dbEnv.throwExecutionError(DbExecutionError.ATTRIBUTE_NOT_FOUND, new Object[]{"function", Operator.if_not_exists});
        }
        if (first == null) {
            return second;
        }
        return first;
    }

    public static boolean eval_EQ(DocumentNode left, DocumentNode right) {
        return left != null && right != null && left.eq(right);
    }

    public static boolean eval_LT(DocumentNode left, DocumentNode right) {
        return OperatorExecutor.typeMatch(left, right) && left.compare(right) < 0;
    }

    private static boolean typeMatch(DocumentNode left, DocumentNode right) {
        return left != null && right != null && left.getNodeType() == right.getNodeType();
    }

    public static boolean eval_LE(DocumentNode left, DocumentNode right) {
        return OperatorExecutor.typeMatch(left, right) && left.compare(right) <= 0;
    }

    public static boolean eval_GT(DocumentNode left, DocumentNode right) {
        return OperatorExecutor.typeMatch(left, right) && left.compare(right) > 0;
    }

    public static boolean eval_GE(DocumentNode left, DocumentNode right) {
        return OperatorExecutor.typeMatch(left, right) && left.compare(right) >= 0;
    }

    public static boolean eval_BETWEEN(DocumentNode left, DocumentNode low, DocumentNode hi) {
        return OperatorExecutor.eval_LE(left, hi) && OperatorExecutor.eval_GE(left, low);
    }

    private boolean getBoolNotNull(DocumentNode b) {
        this.dbEnv.dbAssert(b != null, "OperatorExecutor.getBoolNotNull", "fail", new Object[0]);
        return b.getBooleanValue();
    }

    public boolean eval_NOT(DocumentNode first) {
        return !this.getBoolNotNull(first);
    }

    public boolean eval_AND(DocumentNode left, DocumentNode right) {
        return this.getBoolNotNull(left) && this.getBoolNotNull(right);
    }

    public boolean eval_OR(DocumentNode left, DocumentNode right) {
        return this.getBoolNotNull(left) || this.getBoolNotNull(right);
    }

    public boolean eval_IN(List<DocumentNode> operands) {
        for (int i = 1; i < operands.size(); ++i) {
            if (!OperatorExecutor.eval_EQ(operands.get(0), operands.get(i))) continue;
            return true;
        }
        return false;
    }

    public DocumentNode eval_SIZE(DocumentNode documentNode) {
        if (documentNode == null) {
            return null;
        }
        switch (documentNode.getNodeType()) {
            case STRING: {
                return this.docFactory.makeNumber(new BigDecimal(documentNode.getSValue().length()));
            }
            case BINARY: {
                return this.docFactory.makeNumber(new BigDecimal(documentNode.getRawScalarValue().length));
            }
            case NUMBER_SET: 
            case STRING_SET: 
            case BINARY_SET: {
                return this.docFactory.makeNumber(new BigDecimal(documentNode.getRawSetValue().size()));
            }
            case LIST: 
            case MAP: {
                return this.docFactory.makeNumber(new BigDecimal(documentNode.getChildren().size()));
            }
        }
        return null;
    }

    public boolean attributeType(DocumentNode attributeValue, DocumentNode typeName) {
        if (attributeValue == null) {
            return false;
        }
        return attributeValue.getNodeType().getAbbrName().equals(typeName.getSValue());
    }
}

