/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion;

import com.amazon.ion.BufferConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IonBufferConfiguration
extends BufferConfiguration<IonBufferConfiguration> {
    private final OversizedSymbolTableHandler oversizedSymbolTableHandler;

    private IonBufferConfiguration(Builder builder) {
        super(builder);
        if (builder.getOversizedSymbolTableHandler() == null) {
            this.requireUnlimitedBufferSize();
            this.oversizedSymbolTableHandler = builder.getNoOpOversizedSymbolTableHandler();
        } else {
            this.oversizedSymbolTableHandler = builder.getOversizedSymbolTableHandler();
        }
    }

    public OversizedSymbolTableHandler getOversizedSymbolTableHandler() {
        return this.oversizedSymbolTableHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder
    extends BufferConfiguration.Builder<IonBufferConfiguration, Builder> {
        private static final int MINIMUM_MAX_VALUE_SIZE = 5;
        private static final BufferConfiguration.OversizedValueHandler NO_OP_OVERSIZED_VALUE_HANDLER = new BufferConfiguration.OversizedValueHandler(){

            public void onOversizedValue() {
            }
        };
        private static final BufferConfiguration.DataHandler NO_OP_DATA_HANDLER = new BufferConfiguration.DataHandler(){

            public void onData(int bytes) {
            }
        };
        private static final OversizedSymbolTableHandler NO_OP_OVERSIZED_SYMBOL_TABLE_HANDLER = new OversizedSymbolTableHandler(){

            public void onOversizedSymbolTable() {
            }
        };
        private OversizedSymbolTableHandler oversizedSymbolTableHandler = null;

        private Builder() {
        }

        public static Builder standard() {
            return new Builder();
        }

        public Builder onOversizedSymbolTable(OversizedSymbolTableHandler handler) {
            this.oversizedSymbolTableHandler = handler;
            return this;
        }

        public OversizedSymbolTableHandler getOversizedSymbolTableHandler() {
            return this.oversizedSymbolTableHandler;
        }

        @Override
        public int getMinimumMaximumBufferSize() {
            return 5;
        }

        @Override
        public BufferConfiguration.OversizedValueHandler getNoOpOversizedValueHandler() {
            return NO_OP_OVERSIZED_VALUE_HANDLER;
        }

        @Override
        public BufferConfiguration.DataHandler getNoOpDataHandler() {
            return NO_OP_DATA_HANDLER;
        }

        public OversizedSymbolTableHandler getNoOpOversizedSymbolTableHandler() {
            return NO_OP_OVERSIZED_SYMBOL_TABLE_HANDLER;
        }

        @Override
        public IonBufferConfiguration build() {
            return new IonBufferConfiguration(this);
        }
    }

    public static interface OversizedSymbolTableHandler {
        public void onOversizedSymbolTable() throws Exception;
    }
}

