/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal;

import com.amazonaws.thirdparty.jackson.core.JsonGenerator;
import com.amazonaws.thirdparty.jackson.core.JsonParser;
import com.amazonaws.thirdparty.jackson.databind.DeserializationContext;
import com.amazonaws.thirdparty.jackson.databind.SerializerProvider;
import com.amazonaws.thirdparty.jackson.databind.deser.std.StdDeserializer;
import com.amazonaws.thirdparty.jackson.databind.module.SimpleModule;
import com.amazonaws.thirdparty.jackson.databind.ser.std.StdSerializer;
import com.amazonaws.thirdparty.joda.time.DateTime;
import com.amazonaws.thirdparty.joda.time.DateTimeZone;
import com.amazonaws.thirdparty.joda.time.format.DateTimeFormatter;
import com.amazonaws.thirdparty.joda.time.format.ISODateTimeFormat;
import java.io.IOException;
import java.util.Date;

public class DateModule {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime();
    public static final SimpleModule INSTANCE = new SimpleModule();

    public static Date fromJson(String jsonText) {
        return FORMATTER.parseDateTime(jsonText).toDate();
    }

    static {
        INSTANCE.addSerializer(Date.class, new StdSerializer<Date>(Date.class){

            @Override
            public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(FORMATTER.print(new DateTime((Object)date, DateTimeZone.UTC)));
            }
        });
        INSTANCE.addDeserializer(Date.class, new StdDeserializer<Date>(Date.class){

            @Override
            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return DateModule.fromJson(jsonParser.getValueAsString());
            }
        });
    }
}

