/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RetryStageExecutionRequestMarshaller
implements Marshaller<Request<RetryStageExecutionRequest>, RetryStageExecutionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RetryStageExecutionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RetryStageExecutionRequest> marshall(RetryStageExecutionRequest retryStageExecutionRequest) {
        if (retryStageExecutionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)retryStageExecutionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.RetryStageExecution");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (retryStageExecutionRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(retryStageExecutionRequest.getPipelineName());
            }
            if (retryStageExecutionRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(retryStageExecutionRequest.getStageName());
            }
            if (retryStageExecutionRequest.getPipelineExecutionId() != null) {
                jsonGenerator.writeFieldName("pipelineExecutionId").writeValue(retryStageExecutionRequest.getPipelineExecutionId());
            }
            if (retryStageExecutionRequest.getRetryMode() != null) {
                jsonGenerator.writeFieldName("retryMode").writeValue(retryStageExecutionRequest.getRetryMode());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

