/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directory.model.RadiusSettings;
import java.util.List;

@SdkInternalApi
public class RadiusSettingsMarshaller {
    private static final MarshallingInfo<List> RADIUSSERVERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RadiusServers").build();
    private static final MarshallingInfo<Integer> RADIUSPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RadiusPort").build();
    private static final MarshallingInfo<Integer> RADIUSTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RadiusTimeout").build();
    private static final MarshallingInfo<Integer> RADIUSRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RadiusRetries").build();
    private static final MarshallingInfo<String> SHAREDSECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SharedSecret").build();
    private static final MarshallingInfo<String> AUTHENTICATIONPROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationProtocol").build();
    private static final MarshallingInfo<String> DISPLAYLABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayLabel").build();
    private static final MarshallingInfo<Boolean> USESAMEUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseSameUsername").build();
    private static final RadiusSettingsMarshaller instance = new RadiusSettingsMarshaller();

    public static RadiusSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(RadiusSettings radiusSettings, ProtocolMarshaller protocolMarshaller) {
        if (radiusSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(radiusSettings.getRadiusServers(), RADIUSSERVERS_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getRadiusPort(), RADIUSPORT_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getRadiusTimeout(), RADIUSTIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getRadiusRetries(), RADIUSRETRIES_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getSharedSecret(), SHAREDSECRET_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getAuthenticationProtocol(), AUTHENTICATIONPROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getDisplayLabel(), DISPLAYLABEL_BINDING);
            protocolMarshaller.marshall((Object)radiusSettings.getUseSameUsername(), USESAMEUSERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

