/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.AssetAttributes;
import java.util.List;

public class AssetAttributesJsonMarshaller {
    private static AssetAttributesJsonMarshaller instance;

    public void marshall(AssetAttributes assetAttributes, StructuredJsonGenerator jsonGenerator) {
        if (assetAttributes == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> ipv4AddressesList;
            jsonGenerator.writeStartObject();
            if (assetAttributes.getSchemaVersion() != null) {
                jsonGenerator.writeFieldName("schemaVersion").writeValue(assetAttributes.getSchemaVersion().intValue());
            }
            if (assetAttributes.getAgentId() != null) {
                jsonGenerator.writeFieldName("agentId").writeValue(assetAttributes.getAgentId());
            }
            if (assetAttributes.getAutoScalingGroup() != null) {
                jsonGenerator.writeFieldName("autoScalingGroup").writeValue(assetAttributes.getAutoScalingGroup());
            }
            if (assetAttributes.getAmiId() != null) {
                jsonGenerator.writeFieldName("amiId").writeValue(assetAttributes.getAmiId());
            }
            if (assetAttributes.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(assetAttributes.getHostname());
            }
            if ((ipv4AddressesList = assetAttributes.getIpv4Addresses()) != null) {
                jsonGenerator.writeFieldName("ipv4Addresses");
                jsonGenerator.writeStartArray();
                for (String ipv4AddressesListValue : ipv4AddressesList) {
                    if (ipv4AddressesListValue == null) continue;
                    jsonGenerator.writeValue(ipv4AddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssetAttributesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssetAttributesJsonMarshaller();
        }
        return instance;
    }
}

