/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CopyDBClusterParameterGroupRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyDBClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBClusterParameterGroupRequest>, CopyDBClusterParameterGroupRequest> {
    public Request<CopyDBClusterParameterGroupRequest> marshall(CopyDBClusterParameterGroupRequest copyDBClusterParameterGroupRequest) {
        SdkInternalList tagsList;
        if (copyDBClusterParameterGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBClusterParameterGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CopyDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBClusterParameterGroupRequest.getSourceDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBClusterParameterGroupIdentifier", StringUtils.fromString((String)copyDBClusterParameterGroupRequest.getSourceDBClusterParameterGroupIdentifier()));
        }
        if (copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBClusterParameterGroupIdentifier", StringUtils.fromString((String)copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupIdentifier()));
        }
        if (copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupDescription() != null) {
            request.addParameter("TargetDBClusterParameterGroupDescription", StringUtils.fromString((String)copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupDescription()));
        }
        if (!(tagsList = (SdkInternalList)copyDBClusterParameterGroupRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

