/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.zzcq;
import com.android.billingclient.api.zzcr;
import com.android.billingclient.api.zzcs;
import com.android.billingclient.api.zzct;
import com.android.billingclient.api.zzcu;
import com.android.billingclient.api.zzcv;
import com.android.billingclient.api.zzj;
import com.google.android.gms.internal.play_billing.zzai;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ProductDetails {
    private final String zza;
    private final JSONObject zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final String zzg;
    private final String zzh;
    private final String zzi;
    private final String zzj;
    @Nullable
    private final String zzk;
    @Nullable
    private final List zzl;
    @Nullable
    private final List zzm;

    public int hashCode() {
        return this.zza.hashCode();
    }

    @Nullable
    public OneTimePurchaseOfferDetails getOneTimePurchaseOfferDetails() {
        List list = this.zzm;
        if (list != null && !list.isEmpty()) {
            return (OneTimePurchaseOfferDetails)this.zzm.get(0);
        }
        return null;
    }

    @NonNull
    public String getDescription() {
        return this.zzg;
    }

    @NonNull
    public String getName() {
        return this.zzf;
    }

    @NonNull
    public String getProductId() {
        return this.zzc;
    }

    @NonNull
    public String getProductType() {
        return this.zzd;
    }

    @NonNull
    public String getTitle() {
        return this.zze;
    }

    @NonNull
    public String toString() {
        String string = this.zzb.toString();
        String string2 = String.valueOf(this.zzl);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProductDetails{jsonString='");
        stringBuilder.append(this.zza);
        stringBuilder.append("', parsedJson=");
        stringBuilder.append(string);
        stringBuilder.append(", productId='");
        stringBuilder.append(this.zzc);
        stringBuilder.append("', productType='");
        stringBuilder.append(this.zzd);
        stringBuilder.append("', title='");
        stringBuilder.append(this.zze);
        stringBuilder.append("', productDetailsToken='");
        stringBuilder.append(this.zzh);
        stringBuilder.append("', subscriptionOfferDetails=");
        stringBuilder.append(string2);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Nullable
    public List<SubscriptionOfferDetails> getSubscriptionOfferDetails() {
        return this.zzl;
    }

    /*
     * Enabled aggressive block sorting
     */
    ProductDetails(String arrayList) throws JSONException {
        ArrayList<SubscriptionOfferDetails> arrayList2;
        this.zza = arrayList;
        this.zzb = new JSONObject(this.zza);
        this.zzc = this.zzb.optString("productId");
        this.zzd = this.zzb.optString("type");
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            throw new IllegalArgumentException("Product id cannot be empty.");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            throw new IllegalArgumentException("Product type cannot be empty.");
        }
        this.zze = this.zzb.optString("title");
        this.zzf = this.zzb.optString("name");
        this.zzg = this.zzb.optString("description");
        this.zzi = this.zzb.optString("packageDisplayName");
        this.zzj = this.zzb.optString("iconUrl");
        this.zzh = this.zzb.optString("skuDetailsToken");
        this.zzk = this.zzb.optString("serializedDocid");
        JSONArray jSONArray = this.zzb.optJSONArray("subscriptionOfferDetails");
        if (jSONArray != null) {
            arrayList2 = new ArrayList<SubscriptionOfferDetails>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList2.add(new SubscriptionOfferDetails(jSONArray.getJSONObject(i)));
            }
            this.zzl = arrayList2;
        } else {
            arrayList = this.zzd.equals("subs") || this.zzd.equals("play_pass_subs") ? new ArrayList() : null;
            this.zzl = arrayList;
        }
        JSONObject jSONObject = this.zzb.optJSONObject("oneTimePurchaseOfferDetails");
        jSONArray = this.zzb.optJSONArray("oneTimePurchaseOfferDetailsList");
        arrayList2 = new ArrayList<SubscriptionOfferDetails>();
        if (jSONArray != null) {
            int n = 0;
            while (true) {
                if (n >= jSONArray.length()) {
                    this.zzm = arrayList2;
                    return;
                }
                arrayList2.add((SubscriptionOfferDetails)((Object)new OneTimePurchaseOfferDetails(jSONArray.getJSONObject(n))));
                ++n;
            }
        }
        if (jSONObject != null) {
            arrayList2.add((SubscriptionOfferDetails)((Object)new OneTimePurchaseOfferDetails(jSONObject)));
            this.zzm = arrayList2;
            return;
        }
        this.zzm = null;
    }

    public boolean equals(@Nullable Object o) {
        ProductDetails productDetails;
        if (this == productDetails) {
            return true;
        }
        if (!(productDetails instanceof ProductDetails)) {
            return false;
        }
        productDetails = productDetails;
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)productDetails.zza);
    }

    @NonNull
    public final String zza() {
        return this.zzb.optString("packageName");
    }

    final String zzb() {
        return this.zzh;
    }

    @Nullable
    public String zzc() {
        return this.zzk;
    }

    public static final class SubscriptionOfferDetails {
        private final String zza;
        @Nullable
        private final String zzb;
        private final String zzc;
        private final PricingPhases zzd;
        private final List zze;
        @Nullable
        private final InstallmentPlanDetails zzf;
        @Nullable
        private final zzcv zzg;

        @zzj
        @Nullable
        public InstallmentPlanDetails getInstallmentPlanDetails() {
            return this.zzf;
        }

        @NonNull
        public PricingPhases getPricingPhases() {
            return this.zzd;
        }

        @NonNull
        public String getBasePlanId() {
            return this.zza;
        }

        @Nullable
        public String getOfferId() {
            return this.zzb;
        }

        @NonNull
        public String getOfferToken() {
            return this.zzc;
        }

        @NonNull
        public List<String> getOfferTags() {
            return this.zze;
        }

        /*
         * Enabled aggressive block sorting
         */
        SubscriptionOfferDetails(JSONObject jSONObject) throws JSONException {
            this.zza = jSONObject.optString("basePlanId");
            Object object = jSONObject.optString("offerId");
            if (((String)object).isEmpty()) {
                object = null;
            }
            this.zzb = object;
            this.zzc = jSONObject.getString("offerIdToken");
            object = "pricingPhases";
            this.zzd = new PricingPhases(jSONObject.getJSONArray((String)object));
            object = jSONObject.optJSONObject("installmentPlanDetails");
            object = object == null ? null : new InstallmentPlanDetails((JSONObject)object);
            this.zzf = object;
            object = jSONObject.optJSONObject("transitionPlanDetails");
            object = object == null ? null : new zzcv((JSONObject)object);
            this.zzg = object;
            object = new Object();
            JSONArray jSONArray = jSONObject.optJSONArray("offerTags");
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object.add(jSONArray.getString(i));
                }
            }
            this.zze = object;
        }
    }

    public static final class OneTimePurchaseOfferDetails {
        private final String zza;
        private final long zzb;
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final String zzf;
        private final zzai zzg;
        @Nullable
        private final Long zzh;
        @Nullable
        private final zzcq zzi;
        @Nullable
        private final zzcu zzj;
        @Nullable
        private final zzcr zzk;
        @Nullable
        private final zzcs zzl;
        @Nullable
        private final zzct zzm;

        public long getPriceAmountMicros() {
            return this.zzb;
        }

        @NonNull
        public String getFormattedPrice() {
            return this.zza;
        }

        @NonNull
        public String getPriceCurrencyCode() {
            return this.zzc;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        OneTimePurchaseOfferDetails(JSONObject object) throws JSONException {
            void var1_4;
            this.zza = object.optString("formattedPrice");
            this.zzb = object.optLong("priceAmountMicros");
            this.zzc = object.optString("priceCurrencyCode");
            String string = object.optString("offerIdToken");
            if (string.isEmpty()) {
                string = null;
            }
            this.zzd = string;
            string = object.optString("offerId");
            if (string.isEmpty()) {
                string = null;
            }
            this.zze = string;
            string = object.optString("purchaseOptionId");
            if (string.isEmpty()) {
                string = null;
            }
            this.zzf = string;
            object.optInt("offerType");
            JSONArray jSONArray = object.optJSONArray("offerTags");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    arrayList.add(jSONArray.getString(i));
                }
            }
            this.zzg = zzai.zzj(arrayList);
            Object object2 = object.has("fullPriceMicros") ? Long.valueOf(object.optLong("fullPriceMicros")) : null;
            this.zzh = object2;
            object2 = object.optJSONObject("discountDisplayInfo");
            object2 = object2 == null ? null : new zzcq((JSONObject)object2);
            this.zzi = object2;
            object2 = object.optJSONObject("validTimeWindow");
            object2 = object2 == null ? null : new zzcu((JSONObject)object2);
            this.zzj = object2;
            object2 = object.optJSONObject("limitedQuantityInfo");
            object2 = object2 == null ? null : new zzcr((JSONObject)object2);
            this.zzk = object2;
            object2 = object.optJSONObject("preorderDetails");
            object2 = object2 == null ? null : new zzcs((JSONObject)object2);
            this.zzl = object2;
            JSONObject jSONObject = object.optJSONObject("rentalDetails");
            if (jSONObject == null) {
                Object var1_3 = null;
            } else {
                zzct zzct2 = new zzct(jSONObject);
            }
            this.zzm = var1_4;
        }

        @Nullable
        public final String zza() {
            return this.zzd;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecurrenceMode {
        public static final int INFINITE_RECURRING = 1;
        public static final int FINITE_RECURRING = 2;
        public static final int NON_RECURRING = 3;
    }

    @zzj
    public static final class InstallmentPlanDetails {
        private final int commitmentPaymentsCount;
        private final int subsequentCommitmentPaymentsCount;

        @zzj
        public int getInstallmentPlanCommitmentPaymentsCount() {
            return this.commitmentPaymentsCount;
        }

        @zzj
        public int getSubsequentInstallmentPlanCommitmentPaymentsCount() {
            return this.subsequentCommitmentPaymentsCount;
        }

        /*
         * WARNING - void declaration
         */
        InstallmentPlanDetails(JSONObject installmentPlanDetailsJson) throws JSONException {
            void var1_1;
            this.commitmentPaymentsCount = var1_1.getInt("commitmentPaymentsCount");
            this.subsequentCommitmentPaymentsCount = var1_1.optInt("subsequentCommitmentPaymentsCount");
        }
    }

    public static final class PricingPhase {
        private final String zza;
        private final long zzb;
        private final String zzc;
        private final String zzd;
        private final int zze;
        private final int zzf;

        public int getBillingCycleCount() {
            return this.zze;
        }

        public int getRecurrenceMode() {
            return this.zzf;
        }

        public long getPriceAmountMicros() {
            return this.zzb;
        }

        @NonNull
        public String getBillingPeriod() {
            return this.zzd;
        }

        @NonNull
        public String getFormattedPrice() {
            return this.zza;
        }

        @NonNull
        public String getPriceCurrencyCode() {
            return this.zzc;
        }

        PricingPhase(JSONObject jSONObject) {
            this.zzd = jSONObject.optString("billingPeriod");
            this.zzc = jSONObject.optString("priceCurrencyCode");
            this.zza = jSONObject.optString("formattedPrice");
            this.zzb = jSONObject.optLong("priceAmountMicros");
            this.zzf = jSONObject.optInt("recurrenceMode");
            this.zze = jSONObject.optInt("billingCycleCount");
        }
    }

    public static class PricingPhases {
        private final List zza;

        @NonNull
        public List<PricingPhase> getPricingPhaseList() {
            return this.zza;
        }

        PricingPhases(JSONArray jSONArray) {
            ArrayList<PricingPhase> arrayList = new ArrayList<PricingPhase>();
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.optJSONObject(i);
                    if (jSONObject == null) continue;
                    arrayList.add(new PricingPhase(jSONObject));
                }
            }
            this.zza = arrayList;
        }
    }
}

