/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AccountIdentifiers;
import com.android.billingclient.api.zzcy;
import com.android.billingclient.api.zzk;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String zza;
    private final String zzb;
    private final JSONObject zzc;

    public int getPurchaseState() {
        switch (this.zzc.optInt("purchaseState", 1)) {
            default: {
                return 1;
            }
            case 4: 
        }
        return 2;
    }

    public int getQuantity() {
        return this.zzc.optInt("quantity", 1);
    }

    public int hashCode() {
        return this.zza.hashCode();
    }

    public long getPurchaseTime() {
        return this.zzc.optLong("purchaseTime");
    }

    @Nullable
    public AccountIdentifiers getAccountIdentifiers() {
        String this_ = ((Purchase)((Object)this_)).zzc.optString("obfuscatedAccountId");
        String string = ((Purchase)((Object)this_)).zzc.optString("obfuscatedProfileId");
        if (this_ == null && string == null) {
            return null;
        }
        return new AccountIdentifiers(this_, string);
    }

    @zzk
    @Nullable
    public PendingPurchaseUpdate getPendingPurchaseUpdate() {
        Purchase this_ = this_.zzc.optJSONObject("pendingPurchaseUpdate");
        if (this_ == null) {
            return null;
        }
        return new PendingPurchaseUpdate((JSONObject)this_, null);
    }

    @NonNull
    public String getDeveloperPayload() {
        return this.zzc.optString("developerPayload");
    }

    @Nullable
    public String getOrderId() {
        String this_ = ((Purchase)((Object)this_)).zzc.optString("orderId");
        if (TextUtils.isEmpty((CharSequence)this_)) {
            return null;
        }
        return this_;
    }

    @NonNull
    public String getOriginalJson() {
        return this.zza;
    }

    @NonNull
    public String getPackageName() {
        return this.zzc.optString("packageName");
    }

    @NonNull
    public String getPurchaseToken() {
        Purchase this_ = this_.zzc;
        String string = "purchaseToken";
        Purchase purchase = this_;
        return purchase.optString("token", purchase.optString(string));
    }

    @NonNull
    public String getSignature() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        String this_ = ((Purchase)((Object)this_)).zza;
        return "Purchase. Json: ".concat(String.valueOf(this_));
    }

    @Deprecated
    @NonNull
    public ArrayList<String> getSkus() {
        return this.zza();
    }

    @NonNull
    public List<String> getProducts() {
        return this.zza();
    }

    /*
     * WARNING - void declaration
     */
    public Purchase(@NonNull String jsonPurchaseInfo, @NonNull String signature) throws JSONException {
        void var2_2;
        void var1_1;
        this.zza = var1_1;
        this.zzb = var2_2;
        this.zzc = new JSONObject(this.zza);
    }

    public boolean equals(@Nullable Object o) {
        Purchase purchase;
        if (this == purchase) {
            return true;
        }
        if (!(purchase instanceof Purchase)) {
            return false;
        }
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)(purchase = (Purchase)purchase).getOriginalJson()) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)purchase.getSignature());
    }

    public boolean isAcknowledged() {
        return this.zzc.optBoolean("acknowledged", true);
    }

    public boolean isAutoRenewing() {
        return this.zzc.optBoolean("autoRenewing");
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ArrayList zza() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.zzc.has("productIds")) {
            if (!this.zzc.has("productId")) return arrayList;
            arrayList.add(this.zzc.optString("productId"));
            return arrayList;
        }
        JSONArray jSONArray = this.zzc.optJSONArray("productIds");
        if (jSONArray == null) return arrayList;
        int n = 0;
        while (n < jSONArray.length()) {
            arrayList.add(jSONArray.optString(n));
            ++n;
        }
        return arrayList;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PurchaseState {
        public static final int UNSPECIFIED_STATE = 0;
        public static final int PURCHASED = 1;
        public static final int PENDING = 2;
    }

    @zzk
    public static final class PendingPurchaseUpdate {
        private final JSONObject mParsedJson;

        @NonNull
        public String getPurchaseToken() {
            return this.mParsedJson.optString("purchaseToken");
        }

        @NonNull
        public List<String> getProducts() {
            JSONArray jSONArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.mParsedJson.has("productIds") && (jSONArray = this.mParsedJson.optJSONArray("productIds")) != null) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    arrayList.add(jSONArray.optString(i));
                }
            }
            return arrayList;
        }

        /*
         * WARNING - void declaration
         */
        private PendingPurchaseUpdate(JSONObject mParsedJson) {
            void var1_1;
            this.mParsedJson = var1_1;
        }

        /* synthetic */ PendingPurchaseUpdate(JSONObject jSONObject, zzcy zzcy2) {
            this(jSONObject);
        }
    }
}

