/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class ListenerUtil {
    private static final SparseArray<WeakHashMap<View, WeakReference<?>>> sListeners = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T trackListener(View view, T listener, int listenerResourceId) {
        if (Build.VERSION.SDK_INT >= 14) {
            Object oldValue = view.getTag(listenerResourceId);
            view.setTag(listenerResourceId, listener);
            return (T)oldValue;
        }
        SparseArray<WeakHashMap<View, WeakReference<?>>> sparseArray = sListeners;
        synchronized (sparseArray) {
            WeakReference<T> oldValue;
            WeakHashMap<View, WeakReference<T>> listeners = (WeakHashMap<View, WeakReference<T>>)sListeners.get(listenerResourceId);
            if (listeners == null) {
                listeners = new WeakHashMap<View, WeakReference<T>>();
                sListeners.put(listenerResourceId, listeners);
            }
            if ((oldValue = listener == null ? (WeakReference<T>)listeners.remove(view) : listeners.put(view, new WeakReference<T>(listener))) == null) {
                return null;
            }
            return oldValue.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getListener(View view, int listenerResourceId) {
        if (Build.VERSION.SDK_INT >= 14) {
            return (T)view.getTag(listenerResourceId);
        }
        SparseArray<WeakHashMap<View, WeakReference<?>>> sparseArray = sListeners;
        synchronized (sparseArray) {
            WeakHashMap listeners = (WeakHashMap)sListeners.get(listenerResourceId);
            if (listeners == null) {
                return null;
            }
            WeakReference oldValue = (WeakReference)listeners.get(view);
            if (oldValue == null) {
                return null;
            }
            return oldValue.get();
        }
    }
}

