/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class BaselineLayout
extends ViewGroup {
    private int baseline = -1;

    public BaselineLayout(Context context) {
        super(context, null, 0);
    }

    public BaselineLayout(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    public BaselineLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxWidth = 0;
        int maxHeight = 0;
        int maxChildBaseline = -1;
        int maxChildDescent = -1;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            int baseline = child.getBaseline();
            if (baseline != -1) {
                maxChildBaseline = Math.max(maxChildBaseline, baseline);
                maxChildDescent = Math.max(maxChildDescent, child.getMeasuredHeight() - baseline);
            }
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = View.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        if (maxChildBaseline != -1) {
            maxChildDescent = Math.max(maxChildDescent, this.getPaddingBottom());
            maxHeight = Math.max(maxHeight, maxChildBaseline + maxChildDescent);
            this.baseline = maxChildBaseline;
        }
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(View.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), View.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft();
        int parentRight = right - left - this.getPaddingRight();
        int parentContentWidth = parentRight - parentLeft;
        int parentTop = this.getPaddingTop();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int childLeft = parentLeft + (parentContentWidth - width) / 2;
            int childTop = this.baseline != -1 && child.getBaseline() != -1 ? parentTop + this.baseline - child.getBaseline() : parentTop;
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    public int getBaseline() {
        return this.baseline;
    }
}

