/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StyleRes;
import android.support.design.R;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.PointerIconCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuView;
import android.support.v7.widget.TooltipCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationItemView
extends FrameLayout
implements MenuView.ItemView {
    public static final int INVALID_ITEM_POSITION = -1;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private final int defaultMargin;
    private float shiftAmount;
    private float scaleUpFactor;
    private float scaleDownFactor;
    private int labelVisibilityMode;
    private boolean isShifting;
    private ImageView icon;
    private final TextView smallLabel;
    private final TextView largeLabel;
    private int itemPosition = -1;
    private MenuItemImpl itemData;
    private ColorStateList iconTint;

    public BottomNavigationItemView(@NonNull Context context) {
        this(context, null);
    }

    public BottomNavigationItemView(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        LayoutInflater.from((Context)context).inflate(R.layout.design_bottom_navigation_item, (ViewGroup)this, true);
        this.setBackgroundResource(R.drawable.design_bottom_navigation_item_background);
        this.defaultMargin = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_margin);
        this.icon = (ImageView)this.findViewById(R.id.icon);
        this.smallLabel = (TextView)this.findViewById(R.id.smallLabel);
        this.largeLabel = (TextView)this.findViewById(R.id.largeLabel);
        ViewCompat.setImportantForAccessibility((View)this.smallLabel, (int)2);
        ViewCompat.setImportantForAccessibility((View)this.largeLabel, (int)2);
        this.setFocusable(true);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void initialize(MenuItemImpl itemData, int menuType) {
        this.itemData = itemData;
        this.setCheckable(itemData.isCheckable());
        this.setChecked(itemData.isChecked());
        this.setEnabled(itemData.isEnabled());
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitle());
        this.setId(itemData.getItemId());
        if (!TextUtils.isEmpty((CharSequence)itemData.getContentDescription())) {
            this.setContentDescription(itemData.getContentDescription());
        }
        TooltipCompat.setTooltipText((View)this, (CharSequence)itemData.getTooltipText());
        this.setVisibility(itemData.isVisible() ? 0 : 8);
    }

    public void setItemPosition(int position) {
        this.itemPosition = position;
    }

    public int getItemPosition() {
        return this.itemPosition;
    }

    public void setShifting(boolean shifting) {
        if (this.isShifting != shifting) {
            boolean initialized;
            this.isShifting = shifting;
            boolean bl = initialized = this.itemData != null;
            if (initialized) {
                this.setChecked(this.itemData.isChecked());
            }
        }
    }

    public void setLabelVisibilityMode(int mode) {
        if (this.labelVisibilityMode != mode) {
            boolean initialized;
            this.labelVisibilityMode = mode;
            boolean bl = initialized = this.itemData != null;
            if (initialized) {
                this.setChecked(this.itemData.isChecked());
            }
        }
    }

    public MenuItemImpl getItemData() {
        return this.itemData;
    }

    public void setTitle(CharSequence title) {
        this.smallLabel.setText(title);
        this.largeLabel.setText(title);
        if (this.itemData == null || TextUtils.isEmpty((CharSequence)this.itemData.getContentDescription())) {
            this.setContentDescription(title);
        }
    }

    public void setCheckable(boolean checkable) {
        this.refreshDrawableState();
    }

    public void setChecked(boolean checked) {
        this.largeLabel.setPivotX((float)(this.largeLabel.getWidth() / 2));
        this.largeLabel.setPivotY((float)this.largeLabel.getBaseline());
        this.smallLabel.setPivotX((float)(this.smallLabel.getWidth() / 2));
        this.smallLabel.setPivotY((float)this.smallLabel.getBaseline());
        switch (this.labelVisibilityMode) {
            case -1: {
                if (this.isShifting) {
                    if (checked) {
                        this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                        this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    } else {
                        this.setViewLayoutParams((View)this.icon, this.defaultMargin, 17);
                        this.setViewValues((View)this.largeLabel, 0.5f, 0.5f, 4);
                    }
                    this.smallLabel.setVisibility(4);
                    break;
                }
                if (checked) {
                    this.setViewLayoutParams((View)this.icon, (int)((float)this.defaultMargin + this.shiftAmount), 49);
                    this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    this.setViewValues((View)this.smallLabel, this.scaleUpFactor, this.scaleUpFactor, 4);
                    break;
                }
                this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                this.setViewValues((View)this.largeLabel, this.scaleDownFactor, this.scaleDownFactor, 4);
                this.setViewValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                break;
            }
            case 0: {
                if (checked) {
                    this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                    this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                } else {
                    this.setViewLayoutParams((View)this.icon, this.defaultMargin, 17);
                    this.setViewValues((View)this.largeLabel, 0.5f, 0.5f, 4);
                }
                this.smallLabel.setVisibility(4);
                break;
            }
            case 1: {
                if (checked) {
                    this.setViewLayoutParams((View)this.icon, (int)((float)this.defaultMargin + this.shiftAmount), 49);
                    this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    this.setViewValues((View)this.smallLabel, this.scaleUpFactor, this.scaleUpFactor, 4);
                    break;
                }
                this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                this.setViewValues((View)this.largeLabel, this.scaleDownFactor, this.scaleDownFactor, 4);
                this.setViewValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                break;
            }
            case 2: {
                this.setViewLayoutParams((View)this.icon, this.defaultMargin, 17);
                this.largeLabel.setVisibility(8);
                this.smallLabel.setVisibility(8);
                break;
            }
        }
        this.refreshDrawableState();
        this.setSelected(checked);
    }

    private void setViewLayoutParams(@NonNull View view, int topMargin, int gravity) {
        FrameLayout.LayoutParams viewParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        viewParams.topMargin = topMargin;
        viewParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)viewParams);
    }

    private void setViewValues(@NonNull View view, float scaleX, float scaleY, int visibility) {
        view.setScaleX(scaleX);
        view.setScaleY(scaleY);
        view.setVisibility(visibility);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.smallLabel.setEnabled(enabled);
        this.largeLabel.setEnabled(enabled);
        this.icon.setEnabled(enabled);
        if (enabled) {
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        } else {
            ViewCompat.setPointerIcon((View)this, null);
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.itemData != null && this.itemData.isCheckable() && this.itemData.isChecked()) {
            BottomNavigationItemView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    public void setIcon(Drawable iconDrawable) {
        if (iconDrawable != null) {
            Drawable.ConstantState state = iconDrawable.getConstantState();
            iconDrawable = DrawableCompat.wrap((Drawable)(state == null ? iconDrawable : state.newDrawable())).mutate();
            DrawableCompat.setTintList((Drawable)iconDrawable, (ColorStateList)this.iconTint);
        }
        this.icon.setImageDrawable(iconDrawable);
    }

    public boolean prefersCondensedTitle() {
        return false;
    }

    public boolean showsIcon() {
        return true;
    }

    public void setIconTintList(ColorStateList tint) {
        this.iconTint = tint;
        if (this.itemData != null) {
            this.setIcon(this.itemData.getIcon());
        }
    }

    public void setIconSize(int iconSize) {
        FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.icon.getLayoutParams();
        iconParams.width = iconSize;
        iconParams.height = iconSize;
        this.icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
    }

    public void setTextAppearanceInactive(@StyleRes int inactiveTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.smallLabel, (int)inactiveTextAppearance);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextAppearanceActive(@StyleRes int activeTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.largeLabel, (int)activeTextAppearance);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextColor(@Nullable ColorStateList color) {
        if (color != null) {
            this.smallLabel.setTextColor(color);
            this.largeLabel.setTextColor(color);
        }
    }

    private void calculateTextScaleFactors(float smallLabelSize, float largeLabelSize) {
        this.shiftAmount = smallLabelSize - largeLabelSize;
        this.scaleUpFactor = 1.0f * largeLabelSize / smallLabelSize;
        this.scaleDownFactor = 1.0f * smallLabelSize / largeLabelSize;
    }

    public void setItemBackground(int background) {
        Drawable backgroundDrawable = background == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)background);
        this.setItemBackground(backgroundDrawable);
    }

    public void setItemBackground(@Nullable Drawable background) {
        ViewCompat.setBackground((View)this, (Drawable)background);
    }
}

