/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.os.Build;
import android.support.v4.view.accessibility.AccessibilityEventCompatIcs;
import android.support.v4.view.accessibility.AccessibilityEventCompatJellyBean;
import android.support.v4.view.accessibility.AccessibilityEventCompatKitKat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.view.accessibility.AccessibilityEvent;

public final class AccessibilityEventCompat {
    private static final AccessibilityEventVersionImpl IMPL = Build.VERSION.SDK_INT >= 19 ? new AccessibilityEventKitKatImpl() : (Build.VERSION.SDK_INT >= 16 ? new AccessibilityEventJellyBeanImpl() : (Build.VERSION.SDK_INT >= 14 ? new AccessibilityEventIcsImpl() : new AccessibilityEventStubImpl()));
    public static final int TYPE_VIEW_HOVER_ENTER = 128;
    public static final int TYPE_VIEW_HOVER_EXIT = 256;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_START = 512;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_END = 1024;
    public static final int TYPE_WINDOW_CONTENT_CHANGED = 2048;
    public static final int TYPE_VIEW_SCROLLED = 4096;
    public static final int TYPE_VIEW_TEXT_SELECTION_CHANGED = 8192;
    public static final int TYPE_ANNOUNCEMENT = 16384;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUSED = 32768;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED = 65536;
    public static final int TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY = 131072;
    public static final int TYPE_GESTURE_DETECTION_START = 262144;
    public static final int TYPE_GESTURE_DETECTION_END = 524288;
    public static final int TYPE_TOUCH_INTERACTION_START = 0x100000;
    public static final int TYPE_TOUCH_INTERACTION_END = 0x200000;
    public static final int TYPE_WINDOWS_CHANGED = 0x400000;
    public static final int TYPE_VIEW_CONTEXT_CLICKED = 0x800000;
    public static final int TYPE_ASSIST_READING_CONTEXT = 0x1000000;
    public static final int CONTENT_CHANGE_TYPE_UNDEFINED = 0;
    public static final int CONTENT_CHANGE_TYPE_SUBTREE = 1;
    public static final int CONTENT_CHANGE_TYPE_TEXT = 2;
    public static final int CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION = 4;
    public static final int TYPES_ALL_MASK = -1;

    private AccessibilityEventCompat() {
    }

    public static int getRecordCount(AccessibilityEvent event) {
        return IMPL.getRecordCount(event);
    }

    public static void appendRecord(AccessibilityEvent event, AccessibilityRecordCompat record) {
        IMPL.appendRecord(event, record.getImpl());
    }

    public static AccessibilityRecordCompat getRecord(AccessibilityEvent event, int index) {
        return new AccessibilityRecordCompat(IMPL.getRecord(event, index));
    }

    public static AccessibilityRecordCompat asRecord(AccessibilityEvent event) {
        return new AccessibilityRecordCompat(event);
    }

    public static void setContentChangeTypes(AccessibilityEvent event, int changeTypes) {
        IMPL.setContentChangeTypes(event, changeTypes);
    }

    public static int getContentChangeTypes(AccessibilityEvent event) {
        return IMPL.getContentChangeTypes(event);
    }

    public void setMovementGranularity(AccessibilityEvent event, int granularity) {
        IMPL.setMovementGranularity(event, granularity);
    }

    public int getMovementGranularity(AccessibilityEvent event) {
        return IMPL.getMovementGranularity(event);
    }

    public void setAction(AccessibilityEvent event, int action) {
        IMPL.setAction(event, action);
    }

    public int getAction(AccessibilityEvent event) {
        return IMPL.getAction(event);
    }

    static class AccessibilityEventKitKatImpl
    extends AccessibilityEventJellyBeanImpl {
        AccessibilityEventKitKatImpl() {
        }

        @Override
        public void setContentChangeTypes(AccessibilityEvent event, int types) {
            AccessibilityEventCompatKitKat.setContentChangeTypes(event, types);
        }

        @Override
        public int getContentChangeTypes(AccessibilityEvent event) {
            return AccessibilityEventCompatKitKat.getContentChangeTypes(event);
        }
    }

    static class AccessibilityEventJellyBeanImpl
    extends AccessibilityEventIcsImpl {
        AccessibilityEventJellyBeanImpl() {
        }

        @Override
        public void setMovementGranularity(AccessibilityEvent event, int granularity) {
            AccessibilityEventCompatJellyBean.setMovementGranularity(event, granularity);
        }

        @Override
        public int getMovementGranularity(AccessibilityEvent event) {
            return AccessibilityEventCompatJellyBean.getMovementGranularity(event);
        }

        @Override
        public void setAction(AccessibilityEvent event, int action) {
            AccessibilityEventCompatJellyBean.setAction(event, action);
        }

        @Override
        public int getAction(AccessibilityEvent event) {
            return AccessibilityEventCompatJellyBean.getAction(event);
        }
    }

    static class AccessibilityEventIcsImpl
    extends AccessibilityEventStubImpl {
        AccessibilityEventIcsImpl() {
        }

        @Override
        public void appendRecord(AccessibilityEvent event, Object record) {
            AccessibilityEventCompatIcs.appendRecord(event, record);
        }

        @Override
        public Object getRecord(AccessibilityEvent event, int index) {
            return AccessibilityEventCompatIcs.getRecord(event, index);
        }

        @Override
        public int getRecordCount(AccessibilityEvent event) {
            return AccessibilityEventCompatIcs.getRecordCount(event);
        }
    }

    static class AccessibilityEventStubImpl
    implements AccessibilityEventVersionImpl {
        AccessibilityEventStubImpl() {
        }

        @Override
        public void appendRecord(AccessibilityEvent event, Object record) {
        }

        @Override
        public Object getRecord(AccessibilityEvent event, int index) {
            return null;
        }

        @Override
        public void setContentChangeTypes(AccessibilityEvent event, int types) {
        }

        @Override
        public int getRecordCount(AccessibilityEvent event) {
            return 0;
        }

        @Override
        public int getContentChangeTypes(AccessibilityEvent event) {
            return 0;
        }

        @Override
        public void setMovementGranularity(AccessibilityEvent event, int granularity) {
        }

        @Override
        public int getMovementGranularity(AccessibilityEvent event) {
            return 0;
        }

        @Override
        public void setAction(AccessibilityEvent event, int action) {
        }

        @Override
        public int getAction(AccessibilityEvent event) {
            return 0;
        }
    }

    static interface AccessibilityEventVersionImpl {
        public int getRecordCount(AccessibilityEvent var1);

        public void appendRecord(AccessibilityEvent var1, Object var2);

        public Object getRecord(AccessibilityEvent var1, int var2);

        public void setContentChangeTypes(AccessibilityEvent var1, int var2);

        public int getContentChangeTypes(AccessibilityEvent var1);

        public void setMovementGranularity(AccessibilityEvent var1, int var2);

        public int getMovementGranularity(AccessibilityEvent var1);

        public void setAction(AccessibilityEvent var1, int var2);

        public int getAction(AccessibilityEvent var1);
    }
}

