/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.GuardedBy;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SelfDestructiveThread {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private HandlerThread mThread;
    @GuardedBy(value="mLock")
    private Handler mHandler;
    @GuardedBy(value="mLock")
    private int mGeneration;
    private static final int MSG_INVOKE_RUNNABLE = 1;
    private static final int MSG_DESTRUCTION = 0;
    private Handler.Callback mCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SelfDestructiveThread.this.onInvokeRunnable((Runnable)msg.obj);
                    return true;
                }
                case 0: {
                    SelfDestructiveThread.this.onDestruction();
                    return true;
                }
            }
            return true;
        }
    };
    private final int mDestructAfterMillisec;
    private final int mPriority;
    private final String mThreadName;

    public SelfDestructiveThread(String threadName, int priority, int destructAfterMillisec) {
        this.mThreadName = threadName;
        this.mPriority = priority;
        this.mDestructAfterMillisec = destructAfterMillisec;
        this.mGeneration = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isRunning() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getGeneration() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(Runnable runnable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mThread == null) {
                this.mThread = new HandlerThread(this.mThreadName, this.mPriority);
                this.mThread.start();
                this.mHandler = new Handler(this.mThread.getLooper(), this.mCallback);
                ++this.mGeneration;
            }
            this.mHandler.removeMessages(0);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)runnable));
        }
    }

    public <T> void postAndReply(final Callable<T> callable, final ReplyCallback<T> reply) {
        final Handler callingHandler = new Handler();
        this.post(new Runnable(){

            @Override
            public void run() {
                Object t;
                try {
                    t = callable.call();
                }
                catch (Exception e) {
                    t = null;
                }
                final Object result = t;
                callingHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        reply.onReply(result);
                    }
                });
            }
        });
    }

    public <T> T postAndWait(final Callable<T> callable, int timeoutMillis) throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition cond = lock.newCondition();
        final AtomicReference holder = new AtomicReference();
        final AtomicBoolean running = new AtomicBoolean(true);
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    holder.set(callable.call());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                lock.lock();
                try {
                    running.set(false);
                    cond.signal();
                }
                finally {
                    lock.unlock();
                }
            }
        });
        lock.lock();
        try {
            if (!running.get()) {
                Object v = holder.get();
                return (T)v;
            }
            long remaining = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
            do {
                try {
                    remaining = cond.awaitNanos(remaining);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (running.get()) continue;
                Object v = holder.get();
                return (T)v;
            } while (remaining > 0L);
            throw new InterruptedException("timeout");
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInvokeRunnable(Runnable runnable) {
        runnable.run();
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeMessages(0);
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0), (long)this.mDestructAfterMillisec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDestruction() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHandler.hasMessages(1)) {
                return;
            }
            this.mThread.quit();
            this.mThread = null;
            this.mHandler = null;
        }
    }

    public static interface ReplyCallback<T> {
        public void onReply(T var1);
    }
}

