/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.widget.TintableImageSourceView;
import android.widget.ImageView;

public class ImageViewCompat {
    static final ImageViewCompatImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new LollipopViewCompatImpl() : new BaseViewCompatImpl();

    @Nullable
    public static ColorStateList getImageTintList(@NonNull ImageView view) {
        return IMPL.getImageTintList(view);
    }

    public static void setImageTintList(@NonNull ImageView view, @Nullable ColorStateList tintList) {
        IMPL.setImageTintList(view, tintList);
    }

    @Nullable
    public static PorterDuff.Mode getImageTintMode(@NonNull ImageView view) {
        return IMPL.getImageTintMode(view);
    }

    public static void setImageTintMode(@NonNull ImageView view, @Nullable PorterDuff.Mode mode) {
        IMPL.setImageTintMode(view, mode);
    }

    private ImageViewCompat() {
    }

    @RequiresApi(value=21)
    static class LollipopViewCompatImpl
    extends BaseViewCompatImpl {
        LollipopViewCompatImpl() {
        }

        @Override
        public ColorStateList getImageTintList(ImageView view) {
            return view.getImageTintList();
        }

        @Override
        public void setImageTintList(ImageView view, ColorStateList tintList) {
            view.setImageTintList(tintList);
            if (Build.VERSION.SDK_INT == 21) {
                boolean hasTint;
                Drawable imageViewDrawable = view.getDrawable();
                boolean bl = hasTint = view.getImageTintList() != null && view.getImageTintMode() != null;
                if (imageViewDrawable != null && hasTint) {
                    if (imageViewDrawable.isStateful()) {
                        imageViewDrawable.setState(view.getDrawableState());
                    }
                    view.setImageDrawable(imageViewDrawable);
                }
            }
        }

        @Override
        public void setImageTintMode(ImageView view, PorterDuff.Mode mode) {
            view.setImageTintMode(mode);
            if (Build.VERSION.SDK_INT == 21) {
                boolean hasTint;
                Drawable imageViewDrawable = view.getDrawable();
                boolean bl = hasTint = view.getImageTintList() != null && view.getImageTintMode() != null;
                if (imageViewDrawable != null && hasTint) {
                    if (imageViewDrawable.isStateful()) {
                        imageViewDrawable.setState(view.getDrawableState());
                    }
                    view.setImageDrawable(imageViewDrawable);
                }
            }
        }

        @Override
        public PorterDuff.Mode getImageTintMode(ImageView view) {
            return view.getImageTintMode();
        }
    }

    static class BaseViewCompatImpl
    implements ImageViewCompatImpl {
        BaseViewCompatImpl() {
        }

        @Override
        public ColorStateList getImageTintList(ImageView view) {
            return view instanceof TintableImageSourceView ? ((TintableImageSourceView)view).getSupportImageTintList() : null;
        }

        @Override
        public void setImageTintList(ImageView view, ColorStateList tintList) {
            if (view instanceof TintableImageSourceView) {
                ((TintableImageSourceView)view).setSupportImageTintList(tintList);
            }
        }

        @Override
        public void setImageTintMode(ImageView view, PorterDuff.Mode mode) {
            if (view instanceof TintableImageSourceView) {
                ((TintableImageSourceView)view).setSupportImageTintMode(mode);
            }
        }

        @Override
        public PorterDuff.Mode getImageTintMode(ImageView view) {
            return view instanceof TintableImageSourceView ? ((TintableImageSourceView)view).getSupportImageTintMode() : null;
        }
    }

    static interface ImageViewCompatImpl {
        public ColorStateList getImageTintList(ImageView var1);

        public void setImageTintList(ImageView var1, ColorStateList var2);

        public PorterDuff.Mode getImageTintMode(ImageView var1);

        public void setImageTintMode(ImageView var1, PorterDuff.Mode var2);
    }
}

