/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.RequiresApi;
import android.support.transition.RectEvaluator;
import android.support.transition.TransitionPort;
import android.support.transition.TransitionValues;
import android.support.transition.ViewOverlay;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

@RequiresApi(value=14)
@TargetApi(value=14)
class ChangeBoundsPort
extends TransitionPort {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    private static final String LOG_TAG = "ChangeBounds";
    private static RectEvaluator sRectEvaluator = new RectEvaluator();
    int[] tempLocation = new int[2];
    boolean mResizeClip = false;
    boolean mReparent = false;

    ChangeBoundsPort() {
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    public void setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        values.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
        values.values.put(PROPNAME_PARENT, values.view.getParent());
        values.view.getLocationInWindow(this.tempLocation);
        values.values.put(PROPNAME_WINDOW_X, this.tempLocation[0]);
        values.values.put(PROPNAME_WINDOW_Y, this.tempLocation[1]);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public Animator createAnimator(final ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        boolean parentsEqual;
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        final View view = endValues.view;
        boolean bl = parentsEqual = startParent == endParent || startParent.getId() == endParent.getId();
        if (!this.mReparent || parentsEqual) {
            Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
            Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
            int startLeft = startBounds.left;
            int endLeft = endBounds.left;
            int startTop = startBounds.top;
            int endTop = endBounds.top;
            int startRight = startBounds.right;
            int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 && endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft) {
                    ++numChanges;
                }
                if (startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight) {
                    ++numChanges;
                }
                if (startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (numChanges > 0) {
                if (!this.mResizeClip) {
                    PropertyValuesHolder[] pvh = new PropertyValuesHolder[numChanges];
                    int pvhIndex = 0;
                    if (startLeft != endLeft) {
                        view.setLeft(startLeft);
                    }
                    if (startTop != endTop) {
                        view.setTop(startTop);
                    }
                    if (startRight != endRight) {
                        view.setRight(startRight);
                    }
                    if (startBottom != endBottom) {
                        view.setBottom(startBottom);
                    }
                    if (startLeft != endLeft) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt((String)"left", (int[])new int[]{startLeft, endLeft});
                    }
                    if (startTop != endTop) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt((String)"top", (int[])new int[]{startTop, endTop});
                    }
                    if (startRight != endRight) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt((String)"right", (int[])new int[]{startRight, endRight});
                    }
                    if (startBottom != endBottom) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt((String)"bottom", (int[])new int[]{startBottom, endBottom});
                    }
                    ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])pvh);
                    if (view.getParent() instanceof ViewGroup) {
                        ViewGroup parent = (ViewGroup)view.getParent();
                        TransitionPort.TransitionListenerAdapter transitionListener = new TransitionPort.TransitionListenerAdapter(){
                            boolean mCanceled = false;

                            @Override
                            public void onTransitionCancel(TransitionPort transition) {
                                this.mCanceled = true;
                            }

                            @Override
                            public void onTransitionEnd(TransitionPort transition) {
                                if (!this.mCanceled) {
                                    // empty if block
                                }
                            }

                            @Override
                            public void onTransitionPause(TransitionPort transition) {
                            }

                            @Override
                            public void onTransitionResume(TransitionPort transition) {
                            }
                        };
                        this.addListener(transitionListener);
                    }
                    return anim;
                }
                if (startWidth != endWidth) {
                    view.setRight(endLeft + Math.max(startWidth, endWidth));
                }
                if (startHeight != endHeight) {
                    view.setBottom(endTop + Math.max(startHeight, endHeight));
                }
                if (startLeft != endLeft) {
                    view.setTranslationX((float)(startLeft - endLeft));
                }
                if (startTop != endTop) {
                    view.setTranslationY((float)(startTop - endTop));
                }
                float transXDelta = endLeft - startLeft;
                float transYDelta = endTop - startTop;
                int widthDelta = endWidth - startWidth;
                int heightDelta = endHeight - startHeight;
                numChanges = 0;
                if (transXDelta != 0.0f) {
                    ++numChanges;
                }
                if (transYDelta != 0.0f) {
                    ++numChanges;
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    ++numChanges;
                }
                PropertyValuesHolder[] pvh = new PropertyValuesHolder[numChanges];
                int pvhIndex = 0;
                if (transXDelta != 0.0f) {
                    pvh[pvhIndex++] = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{view.getTranslationX(), 0.0f});
                }
                if (transYDelta != 0.0f) {
                    pvh[pvhIndex++] = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{view.getTranslationY(), 0.0f});
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    Rect tempStartBounds = new Rect(0, 0, startWidth, startHeight);
                    Rect rect = new Rect(0, 0, endWidth, endHeight);
                }
                ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])pvh);
                if (view.getParent() instanceof ViewGroup) {
                    ViewGroup parent = (ViewGroup)view.getParent();
                    TransitionPort.TransitionListenerAdapter transitionListener = new TransitionPort.TransitionListenerAdapter(){
                        boolean mCanceled = false;

                        @Override
                        public void onTransitionCancel(TransitionPort transition) {
                            this.mCanceled = true;
                        }

                        @Override
                        public void onTransitionEnd(TransitionPort transition) {
                            if (!this.mCanceled) {
                                // empty if block
                            }
                        }

                        @Override
                        public void onTransitionPause(TransitionPort transition) {
                        }

                        @Override
                        public void onTransitionResume(TransitionPort transition) {
                        }
                    };
                    this.addListener(transitionListener);
                }
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                    }
                });
                return anim;
            }
        } else {
            int startX = (Integer)startValues.values.get(PROPNAME_WINDOW_X);
            int startY = (Integer)startValues.values.get(PROPNAME_WINDOW_Y);
            int endX = (Integer)endValues.values.get(PROPNAME_WINDOW_X);
            int endY = (Integer)endValues.values.get(PROPNAME_WINDOW_Y);
            if (startX != endX || startY != endY) {
                sceneRoot.getLocationInWindow(this.tempLocation);
                Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
                final BitmapDrawable drawable = new BitmapDrawable(bitmap);
                view.setVisibility(4);
                ViewOverlay.createFrom((View)sceneRoot).add((Drawable)drawable);
                Rect startBounds1 = new Rect(startX - this.tempLocation[0], startY - this.tempLocation[1], startX - this.tempLocation[0] + view.getWidth(), startY - this.tempLocation[1] + view.getHeight());
                Rect endBounds1 = new Rect(endX - this.tempLocation[0], endY - this.tempLocation[1], endX - this.tempLocation[0] + view.getWidth(), endY - this.tempLocation[1] + view.getHeight());
                ObjectAnimator anim = ObjectAnimator.ofObject((Object)drawable, (String)"bounds", (TypeEvaluator)sRectEvaluator, (Object[])new Object[]{startBounds1, endBounds1});
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ViewOverlay.createFrom((View)sceneRoot).remove((Drawable)drawable);
                        view.setVisibility(0);
                    }
                });
                return anim;
            }
        }
        return null;
    }
}

